/*
 * Decompiled with CFR 0.152.
 */
package ghidra.codecompare;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.DualDecompileResultsListener;
import ghidra.app.decompiler.component.DualDecompilerActionContext;
import ghidra.codecompare.CodeDiffFieldPanelCoordinator;
import ghidra.codecompare.CompareFuncsFromMatchedTokensAction;
import ghidra.codecompare.DecompileDataDiff;
import ghidra.codecompare.DecompilerCodeComparisonOptions;
import ghidra.codecompare.DetermineDecompilerDifferencesTask;
import ghidra.codecompare.DiffClangHighlightController;
import ghidra.codecompare.graphanalysis.TokenBin;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import resources.Icons;
import resources.MultiIcon;

public class DecompilerDiffCodeComparisonPanel
extends DecompilerCodeComparisonPanel<CodeDiffFieldPanelCoordinator>
implements DualDecompileResultsListener,
OptionsChangeListener {
    public static final String CODE_DIFF_VIEW = "Decompiler Diff View";
    private DecompileDataDiff decompileDataDiff;
    private DiffClangHighlightController leftHighlightController;
    private DiffClangHighlightController rightHighlightController;
    private CodeDiffFieldPanelCoordinator decompilerFieldPanelCoordinator;
    private MyToggleExactConstantMatching toggleExactConstantMatchingAction;
    private boolean isMatchingConstantsExactly;
    private boolean toggleFlagWhenLastVisible;
    private CompareFuncsFromMatchedTokensAction compareFuncsAction;
    private DecompilerCodeComparisonOptions comparisonOptions;

    public DecompilerDiffCodeComparisonPanel(String owner, PluginTool tool) {
        super(owner, tool);
        this.toggleFlagWhenLastVisible = this.isMatchingConstantsExactly = true;
        this.comparisonOptions = new DecompilerCodeComparisonOptions();
        this.initializeOptions();
        this.leftHighlightController = new DiffClangHighlightController(this.comparisonOptions);
        this.rightHighlightController = new DiffClangHighlightController(this.comparisonOptions);
        this.setHighlightControllers((ClangHighlightController)this.leftHighlightController, (ClangHighlightController)this.rightHighlightController);
        this.leftHighlightController.addListener(this.rightHighlightController);
        this.rightHighlightController.addListener(this.leftHighlightController);
        this.addDualDecompileResultsListener(this);
        this.decompilerFieldPanelCoordinator = new CodeDiffFieldPanelCoordinator(this);
        this.setFieldPanelCoordinator(this.decompilerFieldPanelCoordinator);
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Decompiler Code Comparison");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.comparisonOptions.registerOptions(options);
        this.comparisonOptions.loadOptions(options);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.comparisonOptions.loadOptions(options);
        this.repaint();
    }

    public void setVisible(boolean aFlag) {
        if (aFlag == this.isVisible()) {
            return;
        }
        if (aFlag) {
            if (this.toggleFlagWhenLastVisible != this.isMatchingConstantsExactly && this.decompileDataDiff != null) {
                this.determineDecompilerDifferences();
            }
        } else {
            this.toggleFlagWhenLastVisible = this.isMatchingConstantsExactly;
        }
        super.setVisible(aFlag);
        this.updateActionEnablement();
    }

    public String getTitle() {
        return CODE_DIFF_VIEW;
    }

    public void decompileResultsSet(DecompileData leftDecompileResults, DecompileData rightDecompileResults) {
        if (leftDecompileResults == null || rightDecompileResults == null || leftDecompileResults.getFunction() == null || rightDecompileResults.getFunction() == null) {
            return;
        }
        this.decompileDataDiff = new DecompileDataDiff(leftDecompileResults, rightDecompileResults);
        this.determineDecompilerDifferences();
    }

    List<TokenBin> getHighBins() {
        return this.decompilerFieldPanelCoordinator.getHighBins();
    }

    private void determineDecompilerDifferences() {
        if (this.decompileDataDiff == null) {
            return;
        }
        DetermineDecompilerDifferencesTask task = new DetermineDecompilerDifferencesTask(this.decompileDataDiff, this.isMatchingConstantsExactly, this.leftHighlightController, this.rightHighlightController, this.decompilerFieldPanelCoordinator);
        task.addTaskListener(new TaskListener(){

            public void taskCompleted(Task completedTask) {
            }

            public void taskCancelled(Task cancelledTask) {
            }
        });
        new TaskLauncher((Task)task, (Component)this.getComponent());
    }

    protected void createActions() {
        super.createActions();
        this.toggleExactConstantMatchingAction = new MyToggleExactConstantMatching(((Object)((Object)this)).getClass().getName());
        this.compareFuncsAction = new CompareFuncsFromMatchedTokensAction(this, this.tool);
    }

    public DockingAction[] getActions() {
        DockingAction[] parentActions = super.getActions();
        DockingAction[] myActions = new DockingAction[]{this.toggleExactConstantMatchingAction, this.compareFuncsAction};
        DockingAction[] allActions = new DockingAction[parentActions.length + myActions.length];
        System.arraycopy(parentActions, 0, allActions, 0, parentActions.length);
        System.arraycopy(myActions, 0, allActions, parentActions.length, myActions.length);
        return allActions;
    }

    public void updateActionEnablement() {
        this.toggleExactConstantMatchingAction.setEnabled(this.isVisible());
    }

    protected CodeDiffFieldPanelCoordinator createFieldPanelCoordinator() {
        CodeDiffFieldPanelCoordinator coordinator = new CodeDiffFieldPanelCoordinator(this);
        if (this.decompileDataDiff != null) {
            TaskBuilder.withRunnable(monitor -> {
                try {
                    coordinator.replaceDecompileDataDiff(this.decompileDataDiff, this.isMatchingConstantsExactly, monitor);
                }
                catch (CancelledException e) {
                    coordinator.clearLineNumberPairing();
                }
            }).setTitle("Initializing Code Compare").launchNonModal();
        }
        return coordinator;
    }

    public class MyToggleExactConstantMatching
    extends ToggleDockingAction {
        private final Icon EXACT_CONSTANT_MATCHING_ICON;
        private final Icon NO_EXACT_CONSTANT_MATCHING_ICON;

        public MyToggleExactConstantMatching(String owner) {
            super("Toggle Exact Constant Matching", owner);
            this.EXACT_CONSTANT_MATCHING_ICON = new GIcon("icon.base.source.c");
            this.NO_EXACT_CONSTANT_MATCHING_ICON = new MultiIcon(this.EXACT_CONSTANT_MATCHING_ICON, new Icon[]{Icons.NOT_ALLOWED_ICON});
            this.setToolBarData(new ToolBarData(this.NO_EXACT_CONSTANT_MATCHING_ICON, "toggles"));
            this.setDescription(HTMLUtilities.toHTML((String)"Toggle whether or not constants must\nbe exactly the same value to be a match\nin the Decompiler Diff View."));
            this.setSelected(false);
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return context instanceof DualDecompilerActionContext;
        }

        public void actionPerformed(ActionContext context) {
            boolean bl = DecompilerDiffCodeComparisonPanel.this.isMatchingConstantsExactly = !this.isSelected();
            if (DecompilerDiffCodeComparisonPanel.this.isVisible()) {
                DecompilerDiffCodeComparisonPanel.this.determineDecompilerDifferences();
            }
        }

        public void setSelected(boolean selected) {
            this.getToolBarData().setIcon(selected ? this.NO_EXACT_CONSTANT_MATCHING_ICON : this.EXACT_CONSTANT_MATCHING_ICON);
            super.setSelected(selected);
        }
    }
}

