/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;

public class HorizontalTabPanel<T>
extends JPanel {
    protected final JList<T> list = new JList();
    private final JScrollPane scroll = new JScrollPane(this.list);
    private final JViewport viewport = this.scroll.getViewport();
    private final DefaultListModel<T> model = new DefaultListModel();
    private final JButton left = new JButton("<");
    private final JButton right = new JButton(">");

    public static Color copyColor(Color c) {
        return new Color(c.getRGB());
    }

    public HorizontalTabPanel() {
        this.list.setModel(this.model);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(1);
        this.list.setCellRenderer(new TabListCellRenderer());
        this.list.setOpaque(false);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setBorder(null);
        this.viewport.addChangeListener(this::viewportChanged);
        this.left.setBorder(null);
        this.right.setBorder(null);
        this.left.setContentAreaFilled(false);
        this.right.setContentAreaFilled(false);
        this.left.setOpaque(true);
        this.right.setOpaque(true);
        this.left.addActionListener(this::leftActivated);
        this.right.addActionListener(this::rightActivated);
        this.setLayout(new BorderLayout());
        this.list.setBackground(this.getBackground());
        this.add((Component)this.scroll, "Center");
        this.add((Component)this.left, "West");
        this.add((Component)this.right, "East");
    }

    private void viewportChanged(ChangeEvent e) {
        Dimension paneSize = this.getSize();
        Dimension listSize = this.list.getSize();
        boolean buttonsVisible = paneSize.getWidth() < listSize.getWidth();
        this.left.setVisible(buttonsVisible);
        this.right.setVisible(buttonsVisible);
    }

    private int findFirstVisible(boolean reverse) {
        int i;
        int n = this.model.getSize();
        Rectangle vis = this.list.getVisibleRect();
        int n2 = i = reverse ? n - 1 : 0;
        while (reverse ? i >= 0 : i < n) {
            Rectangle b = this.list.getCellBounds(i, i);
            if (vis.intersects(b)) {
                return i;
            }
            i += reverse ? -1 : 1;
        }
        return -1;
    }

    private int findNextOccluded(int start, boolean reverse) {
        int i;
        if (start == -1) {
            return -1;
        }
        int n = this.model.getSize();
        Rectangle vis = this.list.getVisibleRect();
        int n2 = i = reverse ? start - 1 : start + 1;
        while (reverse ? i >= 0 : i < n) {
            Rectangle b = this.list.getCellBounds(i, i);
            if (!vis.contains(b)) {
                return i;
            }
            i += reverse ? -1 : 1;
        }
        return -1;
    }

    private void leftActivated(ActionEvent e) {
        this.list.ensureIndexIsVisible(this.findNextOccluded(this.findFirstVisible(true), true));
    }

    private void rightActivated(ActionEvent e) {
        this.list.ensureIndexIsVisible(this.findNextOccluded(this.findFirstVisible(false), false));
    }

    public JList<T> getList() {
        return this.list;
    }

    public void addItem(T item) {
        this.model.addElement(item);
        this.revalidate();
    }

    public void removeItem(T item) {
        this.model.removeElement(item);
        this.revalidate();
    }

    public T getSelectedItem() {
        int index = this.list.getSelectedIndex();
        return index < 0 ? null : (T)this.list.getModel().getElementAt(index);
    }

    public void setSelectedItem(T item) {
        int index = this.model.indexOf(item);
        if (index < 0) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(index);
        }
    }

    public T getItem(int index) {
        return this.list.getModel().getElementAt(index);
    }

    public static class TabListCellRenderer<T>
    implements ListCellRenderer<T> {
        protected final Box hBox = Box.createHorizontalBox();
        protected final JLabel label = new JLabel();

        public TabListCellRenderer() {
            this.hBox.setBorder(new BevelBorder(0));
            this.hBox.setOpaque(true);
            this.hBox.add(this.label);
        }

        protected String getText(T value) {
            return value.toString();
        }

        protected Icon getIcon(T value) {
            return null;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.setText(this.getText(value));
            this.label.setIcon(this.getIcon(value));
            if (isSelected) {
                this.label.setForeground(HorizontalTabPanel.copyColor(list.getSelectionForeground()));
                this.hBox.setBackground(list.getSelectionBackground());
            } else {
                this.label.setForeground(list.getForeground());
                this.hBox.setBackground(list.getBackground());
            }
            this.hBox.validate();
            return this.hBox;
        }
    }
}

