/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.linux;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.unix.AbstractEmuUnixSyscallUseropLibrary;
import ghidra.pcode.emu.unix.EmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixUser;
import ghidra.program.model.listing.Program;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEmuLinuxSyscallUseropLibrary<T>
extends AbstractEmuUnixSyscallUseropLibrary<T> {
    public static final int O_MASK_RDWR = 3;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_TRUNC = 512;
    public static final int O_APPEND = 1024;
    protected static final Map<AbstractEmuUnixSyscallUseropLibrary.Errno, Integer> ERRNOS = Map.ofEntries(Map.entry(AbstractEmuUnixSyscallUseropLibrary.Errno.EBADF, 9));

    public AbstractEmuLinuxSyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program) {
        super(machine, fs, program);
    }

    public AbstractEmuLinuxSyscallUseropLibrary(PcodeMachine<T> machine, EmuUnixFileSystem<T> fs, Program program, EmuUnixUser user) {
        super(machine, fs, program, user);
    }

    @Override
    protected Set<EmuUnixFileSystem.OpenFlag> convertFlags(int flags) {
        EnumSet<EmuUnixFileSystem.OpenFlag> result = EnumSet.noneOf(EmuUnixFileSystem.OpenFlag.class);
        int rdwr = flags & 3;
        if (rdwr == 0) {
            result.add(EmuUnixFileSystem.OpenFlag.O_RDONLY);
        }
        if (rdwr == 1) {
            result.add(EmuUnixFileSystem.OpenFlag.O_WRONLY);
        }
        if (rdwr == 2) {
            result.add(EmuUnixFileSystem.OpenFlag.O_RDWR);
        }
        if ((flags & 0x40) != 0) {
            result.add(EmuUnixFileSystem.OpenFlag.O_CREAT);
        }
        if ((flags & 0x200) != 0) {
            result.add(EmuUnixFileSystem.OpenFlag.O_TRUNC);
        }
        if ((flags & 0x400) != 0) {
            result.add(EmuUnixFileSystem.OpenFlag.O_APPEND);
        }
        return result;
    }

    @Override
    protected int getErrno(AbstractEmuUnixSyscallUseropLibrary.Errno err) {
        Integer errno = ERRNOS.get((Object)err);
        if (errno == null) {
            throw new AssertionError((Object)("Do not know errno value for " + err));
        }
        return errno;
    }
}

