/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.schedule.TickStep;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public interface Scheduler {
    public static Scheduler oneThread(TraceThread thread) {
        final long key = thread == null ? -1L : thread.getKey();
        return new Scheduler(){

            @Override
            public TickStep nextSlice(Trace trace) {
                return new TickStep(key, 1000L);
            }
        };
    }

    public TickStep nextSlice(Trace var1);

    default public RunResult run(Trace trace, TraceThread eventThread, PcodeMachine<?> machine, TaskMonitor monitor) {
        TraceThreadManager tm = trace.getThreadManager();
        TraceSchedule completedSteps = TraceSchedule.snap(0L);
        PcodeThread emuThread = null;
        int completedTicks = 0;
        try {
            while (true) {
                TickStep slice;
                if ((emuThread = machine.getThread((eventThread = (slice = this.nextSlice(trace)).getThread(tm, eventThread)).getPath(), true)).getFrame() != null) {
                    emuThread.finishInstruction();
                }
                int i = 0;
                while ((long)i < slice.tickCount) {
                    monitor.checkCancelled();
                    emuThread.stepInstruction();
                    ++completedTicks;
                    ++i;
                }
                completedSteps = completedSteps.steppedForward(eventThread, completedTicks);
                completedTicks = 0;
            }
        }
        catch (PcodeExecutionException e) {
            completedSteps = completedSteps.steppedForward(eventThread, completedTicks);
            PcodeFrame frame = emuThread.getFrame();
            if (frame == null) {
                return new RecordRunResult(completedSteps, e);
            }
            frame.stepBack();
            int count = frame.count();
            if (count == 0) {
                emuThread.dropInstruction();
                return new RecordRunResult(completedSteps, e);
            }
            return new RecordRunResult(completedSteps.steppedPcodeForward(eventThread, count + 1), e);
        }
        catch (CancelledException e) {
            return new RecordRunResult(completedSteps.steppedForward(eventThread, completedTicks), e);
        }
    }

    public record RecordRunResult(TraceSchedule schedule, Throwable error) implements RunResult
    {
    }

    public static interface RunResult {
        public TraceSchedule schedule();

        public Throwable error();
    }
}

