/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TypedEventDispatcher {
    private Map<TraceChangeType<?, ?>, EventRecordHandler<?, ?>> typedMap = new HashMap();
    private Map<Integer, Consumer<DomainObjectChangeRecord>> untypedMap = new HashMap<Integer, Consumer<DomainObjectChangeRecord>>();
    protected Consumer<DomainObjectChangeRecord> restoredHandler = null;

    protected <T, U> void listenFor(TraceChangeType<T, U> type, EventRecordHandler<T, U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceChangeType<T, U> type, FullEventRecordHandler<? super T, ? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceChangeType<T, U> type, AffectedObjectHandler<? super T> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceChangeType<T, U> type, AffectedObjectOnlyHandler<? super T> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceChangeType<T, U> type, AffectedAndValuesOnlyHandler<? super T, ? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceChangeType<T, U> type, ValuesOnlyHandler<? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected <T, U> void listenFor(TraceChangeType<T, U> type, SpaceValuesHandler<? super U> handler) {
        this.typedMap.put(type, handler);
    }

    protected void listenFor(TraceChangeType<?, ?> type, IgnoreValuesHandler handler) {
        this.typedMap.put(type, handler);
    }

    protected void listenFor(TraceChangeType<?, ?> type, IgnoreAllHandler handler) {
        this.typedMap.put(type, handler);
    }

    protected void listenForUntyped(int type, Consumer<DomainObjectChangeRecord> handler) {
        if (type == 4) {
            this.restoredHandler = handler;
        } else {
            this.untypedMap.put(type, handler);
        }
    }

    public void handleChangeRecord(DomainObjectChangeRecord rec) {
        if (rec.getEventType() == 4 && this.restoredHandler != null) {
            this.restoredHandler.accept(rec);
            return;
        }
        if (rec instanceof TraceChangeRecord) {
            TraceChangeRecord cr = (TraceChangeRecord)rec;
            this.handleTraceChangeRecord(cr);
            return;
        }
        Consumer<DomainObjectChangeRecord> handler = this.untypedMap.get(rec.getEventType());
        if (null != handler) {
            handler.accept(rec);
            return;
        }
        this.unhandled(rec);
    }

    public void handleTraceChangeRecord(TraceChangeRecord<?, ?> rec) {
        EventRecordHandler<?, ?> handler = this.typedMap.get(rec.getType());
        if (handler != null) {
            handler.handle(rec);
        }
    }

    protected void unhandled(DomainObjectChangeRecord rec) {
    }

    public static interface EventRecordHandler<T, U> {
        public void handle(TraceChangeRecord<T, U> var1);
    }

    public static interface IgnoreAllHandler
    extends EventRecordHandler<Object, Object> {
        public void handle();

        @Override
        default public void handle(TraceChangeRecord<Object, Object> record) {
            this.handle();
        }
    }

    public static interface IgnoreValuesHandler
    extends EventRecordHandler<Object, Object> {
        public void handle(TraceAddressSpace var1);

        @Override
        default public void handle(TraceChangeRecord<Object, Object> record) {
            this.handle(record.getSpace());
        }
    }

    public static interface ValuesOnlyHandler<U>
    extends EventRecordHandler<Void, U> {
        public void handle(U var1, U var2);

        @Override
        default public void handle(TraceChangeRecord<Void, U> record) {
            this.handle(record.getOldValue(), record.getNewValue());
        }
    }

    public static interface SpaceValuesHandler<U>
    extends EventRecordHandler<Void, U> {
        public void handle(TraceAddressSpace var1, U var2, U var3);

        @Override
        default public void handle(TraceChangeRecord<Void, U> record) {
            this.handle(record.getSpace(), record.getOldValue(), record.getNewValue());
        }
    }

    public static interface AffectedAndValuesOnlyHandler<T, U>
    extends EventRecordHandler<T, U> {
        public void handle(T var1, U var2, U var3);

        @Override
        default public void handle(TraceChangeRecord<T, U> record) {
            this.handle(record.getAffectedObject(), record.getOldValue(), record.getNewValue());
        }
    }

    public static interface AffectedObjectOnlyHandler<T>
    extends EventRecordHandler<T, Void> {
        public void handle(T var1);

        @Override
        default public void handle(TraceChangeRecord<T, Void> record) {
            this.handle(record.getAffectedObject());
        }
    }

    public static interface AffectedObjectHandler<T>
    extends EventRecordHandler<T, Void> {
        public void handle(TraceAddressSpace var1, T var2);

        @Override
        default public void handle(TraceChangeRecord<T, Void> record) {
            this.handle(record.getSpace(), record.getAffectedObject());
        }
    }

    public static interface FullEventRecordHandler<T, U>
    extends EventRecordHandler<T, U> {
        public void handle(TraceAddressSpace var1, T var2, U var3, U var4);

        @Override
        default public void handle(TraceChangeRecord<T, U> record) {
            this.handle(record.getSpace(), record.getAffectedObject(), record.getOldValue(), record.getNewValue());
        }
    }
}

