/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import db.Transaction;
import ghidra.framework.data.DomainObjectEventQueues;
import ghidra.framework.data.DomainObjectFileListener;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.database.IntRangeMap;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewRegisterListing;
import ghidra.trace.database.program.DBTraceProgramViewRegisterMemory;
import ghidra.trace.database.program.DBTraceProgramViewRegistersReferenceManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewMemory;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DBTraceProgramViewRegisters
implements TraceProgramView {
    protected final DomainObjectEventQueues eventQueues;
    private final DBTraceProgramView view;
    private final TraceThread thread;
    private final DBTraceProgramViewRegisterListing listing;
    private final DBTraceProgramViewRegisterMemory memory;
    private final DBTraceProgramViewRegistersReferenceManager referenceManager;

    public DBTraceProgramViewRegisters(DBTraceProgramView view, DBTraceCodeSpace codeSpace, DBTraceMemorySpace memorySpace) {
        this.view = view;
        this.thread = codeSpace.getThread();
        this.eventQueues = new DomainObjectEventQueues((DomainObject)this, 100, view.trace.getLock());
        this.listing = new DBTraceProgramViewRegisterListing(view, codeSpace);
        this.memory = new DBTraceProgramViewRegisterMemory(view, memorySpace);
        this.referenceManager = new DBTraceProgramViewRegistersReferenceManager(view, this.thread);
    }

    public Listing getListing() {
        return this.listing;
    }

    public AddressMap getAddressMap() {
        return null;
    }

    public TraceBasedDataTypeManager getDataTypeManager() {
        return this.view.getDataTypeManager();
    }

    public FunctionManager getFunctionManager() {
        return this.view.getFunctionManager();
    }

    public ProgramUserData getProgramUserData() {
        return null;
    }

    public SymbolTable getSymbolTable() {
        return this.view.getSymbolTable();
    }

    public ExternalManager getExternalManager() {
        return this.view.getExternalManager();
    }

    public EquateTable getEquateTable() {
        return this.view.getEquateTable();
    }

    @Override
    public TraceProgramViewMemory getMemory() {
        return this.memory;
    }

    public ReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    public BookmarkManager getBookmarkManager() {
        return this.view.getBookmarkManager();
    }

    public int getDefaultPointerSize() {
        return this.view.getDefaultPointerSize();
    }

    public String getCompiler() {
        return this.view.getCompiler();
    }

    public void setCompiler(String compiler) {
        this.view.setCompiler(compiler);
    }

    public CategoryPath getPreferredRootNamespaceCategoryPath() {
        return this.view.getPreferredRootNamespaceCategoryPath();
    }

    public void setPreferredRootNamespaceCategoryPath(String categoryPath) {
        this.view.setPreferredRootNamespaceCategoryPath(categoryPath);
    }

    public String getExecutablePath() {
        return this.view.getExecutablePath();
    }

    public void setExecutablePath(String path) {
        this.view.setExecutablePath(path);
    }

    public String getExecutableFormat() {
        return this.view.getExecutableFormat();
    }

    public void setExecutableFormat(String format) {
        this.view.setExecutableFormat(format);
    }

    public String getExecutableMD5() {
        return this.view.getExecutableMD5();
    }

    public void setExecutableMD5(String md5) {
        this.view.setExecutableMD5(md5);
    }

    public void setExecutableSHA256(String sha256) {
        this.view.setExecutableSHA256(sha256);
    }

    public String getExecutableSHA256() {
        return this.view.getExecutableSHA256();
    }

    public Date getCreationDate() {
        return this.view.getCreationDate();
    }

    public RelocationTable getRelocationTable() {
        return this.view.getRelocationTable();
    }

    public Language getLanguage() {
        return this.view.getLanguage();
    }

    public CompilerSpec getCompilerSpec() {
        return this.view.getCompilerSpec();
    }

    public LanguageID getLanguageID() {
        return this.view.getLanguageID();
    }

    public PropertyMapManager getUsrPropertyManager() {
        return this.view.getUsrPropertyManager();
    }

    public ProgramContext getProgramContext() {
        return this.view.getProgramContext();
    }

    public Address getMinAddress() {
        return this.view.getLanguage().getAddressFactory().getRegisterSpace().getMinAddress();
    }

    public Address getMaxAddress() {
        return this.view.getLanguage().getAddressFactory().getRegisterSpace().getMaxAddress();
    }

    public ProgramChangeSet getChanges() {
        return this.view.getChanges();
    }

    public AddressFactory getAddressFactory() {
        return this.view.getAddressFactory();
    }

    public Address[] parseAddress(String addrStr) {
        return this.view.parseAddress(addrStr);
    }

    public Address[] parseAddress(String addrStr, boolean caseSensitive) {
        return this.view.parseAddress(addrStr, caseSensitive);
    }

    public void invalidate() {
        this.view.invalidate();
    }

    public Register getRegister(String name) {
        return this.view.getRegister(name);
    }

    public Register getRegister(Address addr) {
        return this.view.getRegister(addr);
    }

    public Register[] getRegisters(Address addr) {
        return this.view.getRegisters(addr);
    }

    public Register getRegister(Address addr, int size) {
        return this.view.getRegister(addr, size);
    }

    public Register getRegister(Varnode varnode) {
        return this.view.getRegister(varnode);
    }

    public Address getImageBase() {
        return this.view.getImageBase();
    }

    public ProgramOverlayAddressSpace createOverlaySpace(String overlaySpaceName, AddressSpace baseSpace) throws IllegalStateException, DuplicateNameException, InvalidNameException, LockException {
        return this.view.createOverlaySpace(overlaySpaceName, baseSpace);
    }

    public void renameOverlaySpace(String overlaySpaceName, String newName) throws NotFoundException, InvalidNameException, DuplicateNameException, LockException {
        this.view.renameOverlaySpace(overlaySpaceName, newName);
    }

    public boolean removeOverlaySpace(String overlaySpaceName) throws LockException, NotFoundException {
        return this.view.removeOverlaySpace(overlaySpaceName);
    }

    public void setImageBase(Address base, boolean commit) throws AddressOverflowException, LockException, IllegalStateException {
        this.view.setImageBase(base, commit);
    }

    public void restoreImageBase() {
        this.view.restoreImageBase();
    }

    public void setLanguage(Language language, CompilerSpecID compilerSpecID, boolean forceRedisassembly, TaskMonitor monitor) throws IllegalStateException, IncompatibleLanguageException, LockException {
        this.view.setLanguage(language, compilerSpecID, forceRedisassembly, monitor);
    }

    public Namespace getGlobalNamespace() {
        return this.view.getGlobalNamespace();
    }

    public AddressSetPropertyMap createAddressSetPropertyMap(String name) throws DuplicateNameException {
        return this.view.getAddressSetPropertyMap(name);
    }

    public IntRangeMap createIntRangeMap(String name) throws DuplicateNameException {
        return this.view.createIntRangeMap(name);
    }

    public AddressSetPropertyMap getAddressSetPropertyMap(String name) {
        return this.view.getAddressSetPropertyMap(name);
    }

    public IntRangeMap getIntRangeMap(String name) {
        return this.view.getIntRangeMap(name);
    }

    public void deleteAddressSetPropertyMap(String name) {
        this.view.deleteAddressSetPropertyMap(name);
    }

    public void deleteIntRangeMap(String name) {
        this.view.deleteIntRangeMap(name);
    }

    public long getUniqueProgramID() {
        return this.view.getUniqueProgramID();
    }

    public Transaction openTransaction(String description) throws IllegalStateException {
        return this.view.openTransaction(description);
    }

    public int startTransaction(String description) {
        return this.view.startTransaction(description);
    }

    public int startTransaction(String description, AbortedTransactionListener listener) {
        return this.view.startTransaction(description, listener);
    }

    public void endTransaction(int transactionID, boolean commit) {
        this.view.endTransaction(transactionID, commit);
    }

    public TransactionInfo getCurrentTransactionInfo() {
        return this.view.getCurrentTransactionInfo();
    }

    public boolean hasTerminatedTransaction() {
        return this.view.hasTerminatedTransaction();
    }

    public DomainObject[] getSynchronizedDomainObjects() {
        return this.view.getSynchronizedDomainObjects();
    }

    public void addSynchronizedDomainObject(DomainObject domainObj) throws LockException {
        this.view.addSynchronizedDomainObject(domainObj);
    }

    public void releaseSynchronizedDomainObject() throws LockException {
        this.view.releaseSynchronizedDomainObject();
    }

    public boolean isChanged() {
        return this.view.isChanged();
    }

    public void setTemporary(boolean state) {
        this.view.setTemporary(state);
    }

    public boolean isTemporary() {
        return this.view.isTemporary();
    }

    public boolean isChangeable() {
        return this.view.isChangeable();
    }

    public boolean canSave() {
        return this.view.canSave();
    }

    public void save(String comment, TaskMonitor monitor) throws IOException, CancelledException {
        this.view.save(comment, monitor);
    }

    public void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        this.view.saveToPackedFile(outputFile, monitor);
    }

    public void release(Object consumer) {
        this.view.release(consumer);
    }

    public void addListener(DomainObjectListener dol) {
        this.eventQueues.addListener(dol);
    }

    public void removeListener(DomainObjectListener dol) {
        this.eventQueues.removeListener(dol);
    }

    public void addCloseListener(DomainObjectClosedListener listener) {
        this.view.addCloseListener(listener);
    }

    public void removeCloseListener(DomainObjectClosedListener listener) {
        this.view.removeCloseListener(listener);
    }

    public void addDomainFileListener(DomainObjectFileListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeDomainFileListener(DomainObjectFileListener listener) {
        throw new UnsupportedOperationException();
    }

    public EventQueueID createPrivateEventQueue(DomainObjectListener listener, int maxDelay) {
        return this.eventQueues.createPrivateEventQueue(listener, maxDelay);
    }

    public boolean removePrivateEventQueue(EventQueueID id) {
        return this.removePrivateEventQueue(id);
    }

    public String getDescription() {
        return this.view.getDescription();
    }

    public String getName() {
        return this.view.getName();
    }

    public void setName(String name) {
        this.view.setName(name);
    }

    public DomainFile getDomainFile() {
        return this.view.getDomainFile();
    }

    public boolean addConsumer(Object consumer) {
        return this.view.addConsumer(consumer);
    }

    public ArrayList<Object> getConsumerList() {
        return this.view.getConsumerList();
    }

    public boolean isUsedBy(Object consumer) {
        return this.view.isUsedBy(consumer);
    }

    public void setEventsEnabled(boolean enabled) {
        this.view.setEventsEnabled(enabled);
    }

    public boolean isSendingEvents() {
        return this.view.isSendingEvents();
    }

    public void flushEvents() {
        this.view.flushEvents();
    }

    public void flushPrivateEventQueue(EventQueueID id) {
        this.view.flushPrivateEventQueue(id);
    }

    public boolean canLock() {
        return this.view.canLock();
    }

    public boolean isLocked() {
        return this.view.isLocked();
    }

    public boolean lock(String reason) {
        return this.view.lock(reason);
    }

    public void forceLock(boolean rollback, String reason) {
        this.view.forceLock(rollback, reason);
    }

    public void unlock() {
        this.view.unlock();
    }

    public List<String> getOptionsNames() {
        return this.view.getOptionsNames();
    }

    public Options getOptions(String propertyListName) {
        return this.view.getOptions(propertyListName);
    }

    public boolean isClosed() {
        return this.view.isClosed();
    }

    public boolean hasExclusiveAccess() {
        return this.view.hasExclusiveAccess();
    }

    public Map<String, String> getMetadata() {
        return this.view.getMetadata();
    }

    public long getModificationNumber() {
        return this.view.getModificationNumber();
    }

    public boolean canUndo() {
        return this.view.canUndo();
    }

    public boolean canRedo() {
        return this.view.canRedo();
    }

    public void clearUndo() {
        this.view.clearUndo();
    }

    public void undo() throws IOException {
        this.view.undo();
    }

    public void redo() throws IOException {
        this.view.redo();
    }

    public String getUndoName() {
        return this.view.getUndoName();
    }

    public String getRedoName() {
        return this.view.getRedoName();
    }

    public List<String> getAllUndoNames() {
        return this.view.getAllUndoNames();
    }

    public List<String> getAllRedoNames() {
        return this.view.getAllRedoNames();
    }

    public void addTransactionListener(TransactionListener listener) {
        this.view.addTransactionListener(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.view.removeTransactionListener(listener);
    }

    @Override
    public Trace getTrace() {
        return this.view.getTrace();
    }

    @Override
    public long getSnap() {
        return this.view.getSnap();
    }

    @Override
    public TraceTimeViewport getViewport() {
        return this.view.getViewport();
    }

    @Override
    public Long getMaxSnap() {
        return this.view.getMaxSnap();
    }

    @Override
    public TraceProgramView getViewRegisters(TraceThread thread, boolean createIfAbsent) {
        return this.view.getViewRegisters(thread, createIfAbsent);
    }
}

