/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBStream;
import SWIG.SBValue;
import agent.lldb.model.iface2.LldbModelTargetStackFrameRegister;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameRegisterBankImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.ConversionUtils;
import ghidra.dbg.util.PathUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="RegisterValue", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class LldbModelTargetStackFrameRegisterImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetStackFrameRegister {
    String value = this.getValue();

    protected static String indexRegister(SBValue register) {
        return register.GetName();
    }

    protected static String keyRegister(SBValue register) {
        return PathUtils.makeKey((String)LldbModelTargetStackFrameRegisterImpl.indexRegister(register));
    }

    public LldbModelTargetStackFrameRegisterImpl(LldbModelTargetStackFrameRegisterBankImpl bank, SBValue register) {
        super(bank.getModel(), (TargetObject)bank, LldbModelTargetStackFrameRegisterImpl.keyRegister(register), register, "Register");
        this.changeAttributes(List.of(), Map.of("_container", bank.getContainer(), "_length", this.getBitLength(), "_display", this.getDescription(0), "_value", this.value == null ? "0" : this.value, "_modified", false), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBValue val = (SBValue)this.getModelObject();
        val.GetDescription(stream);
        return stream.GetData();
    }

    @Override
    public int getBitLength() {
        return (int)(this.getRegister().GetByteSize() * 8L);
    }

    public String getValue() {
        String val = this.getRegister().GetValue();
        if (val == null) {
            return null;
        }
        if (!val.startsWith("0x")) {
            return val;
        }
        return val.substring(2);
    }

    @Override
    public SBValue getRegister() {
        return (SBValue)this.getModelObject();
    }

    @Override
    public byte[] getBytes() {
        String oldValue = this.value;
        this.value = this.getValue();
        if (this.value == null) {
            return new byte[0];
        }
        if (this.value.startsWith("{")) {
            String trim = this.value.substring(1, this.value.length() - 1);
            String[] split = trim.split(" ");
            this.value = split[0].substring(2) + split[1].substring(2);
        }
        this.changeAttributes(List.of(), Map.of("_value", this.value), "Refreshed");
        if (!this.value.equals("0")) {
            String newval = this.getDescription(0);
            this.changeAttributes(List.of(), Map.of("_display", newval), "Refreshed");
            this.setModified(!this.value.equals(oldValue));
        }
        try {
            BigInteger val = new BigInteger(this.value, 16);
            byte[] bytes = ConversionUtils.bigIntegerToBytes((int)((int)this.getRegister().GetByteSize()), (BigInteger)val);
            return bytes;
        }
        catch (NumberFormatException nfe) {
            return new byte[0];
        }
    }

    public String getDisplay() {
        return this.getValue() == null ? this.getName() : this.getName() + " : " + this.getValue();
    }
}

