/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.RunMode;
import SWIG.SBError;
import SWIG.SBStream;
import SWIG.SBThread;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbEvaluateCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbCommandErrorEvent;
import agent.lldb.manager.evt.LldbRunningEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.dbg.target.TargetSteppable;
import ghidra.util.Msg;
import java.util.Map;

public class LldbStepCommand
extends AbstractLldbCommand<Void> {
    private SBThread thread;
    private TargetSteppable.TargetStepKind kind;
    private Map<String, ?> args;
    private String lastCommand = "";

    public LldbStepCommand(LldbManagerImpl manager, SBThread thread, TargetSteppable.TargetStepKind kind, Map<String, ?> args) {
        super(manager);
        this.thread = thread;
        this.kind = kind;
        this.args = args;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            return evt instanceof LldbCommandErrorEvent || !pending.findAllOf(LldbRunningEvent.class).isEmpty();
        }
        if (evt instanceof LldbRunningEvent) {
            pending.claim(evt);
            return !pending.findAllOf(AbstractLldbCompletedCommandEvent.class).isEmpty();
        }
        return false;
    }

    @Override
    public void invoke() {
        RunMode rm = RunMode.eOnlyThisThread;
        if (this.thread == null || !this.thread.IsValid()) {
            this.thread = this.manager.getCurrentThread();
            rm = RunMode.eAllThreads;
        }
        if (this.kind == null) {
            this.kind = (TargetSteppable.TargetStepKind)this.args.get("Kind");
        }
        SBError error = new SBError();
        switch (this.kind) {
            case INTO: {
                this.thread.StepInstruction(false, error);
                break;
            }
            case OVER: {
                this.thread.StepInstruction(true, error);
                break;
            }
            case LINE: {
                this.thread.StepInto();
                break;
            }
            case OVER_LINE: {
                this.thread.StepOver(rm, error);
                break;
            }
            case RETURN: {
                this.thread.StepOut(error);
                break;
            }
            case FINISH: {
                this.thread.StepOutOfFrame(this.thread.GetSelectedFrame(), error);
                break;
            }
            case EXTENDED: {
                this.manager.execute(new LldbEvaluateCommand(this.manager, this.lastCommand));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Step " + this.kind.name() + " not supported");
            }
        }
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)(error.GetType() + " while stepping: " + stream.GetData()));
        }
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(String lastCommand) {
        this.lastCommand = lastCommand;
    }
}

