/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerErrorHandler;
import ghidra.util.datastruct.ListenerErrorHandlerFactory;

public class DataStructureErrorHandlerFactory {
    static ListenerErrorHandlerFactory listenerFactory = new ListenerErrorHandlerFactory(){

        @Override
        public ListenerErrorHandler createErrorHandler() {
            return new DefaultListenerErrorHandler();
        }
    };

    public static ListenerErrorHandler createListenerErrorHandler() {
        return listenerFactory.createErrorHandler();
    }

    private static class DefaultListenerErrorHandler
    implements ListenerErrorHandler {
        private DefaultListenerErrorHandler() {
        }

        @Override
        public void handleError(Object listener, Throwable t) {
            Msg.error((Object)listener, (Object)("Listener " + listener + " caused unexpected exception"), (Throwable)t);
        }
    }
}

