/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.OpenMode;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.app.util.task.OpenProgramRequest;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.feature.vt.api.correlator.program.ImpliedMatchProgramCorrelator;
import ghidra.feature.vt.api.correlator.program.ManualMatchProgramCorrelator;
import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.db.VTMatchSetTableDBAdapter;
import ghidra.feature.vt.api.db.VTMatchTagDB;
import ghidra.feature.vt.api.db.VTMatchTagDBAdapter;
import ghidra.feature.vt.api.impl.VTChangeManager;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.impl.VersionTrackingChangeRecord;
import ghidra.feature.vt.api.main.AssociationHook;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class VTSessionDB
extends DomainObjectAdapterDB
implements VTSession,
VTChangeManager {
    private static final Field[] COL_FIELDS = new Field[]{StringField.INSTANCE};
    private static final String[] COL_TYPES = new String[]{"Value"};
    private static final Schema SCHEMA = new Schema(0, (Field)StringField.INSTANCE, "Key", COL_FIELDS, COL_TYPES);
    private static final String PROGRAM_ID_PROPERTYLIST_NAME = "ProgramIDs";
    private static final String SOURCE_PROGRAM_ID_PROPERTY_KEY = "SourceProgramID";
    private static final String DESTINATION_PROGRAM_ID_PROPERTY_KEY = "DestinationProgramID";
    private static final String UNUSED_DEFAULT_NAME = "Untitled";
    private static final int EVENT_NOTIFICATION_DELAY = 500;
    private static final int EVENT_BUFFER_SIZE = 100;
    private static final long MANUAL_MATCH_SET_ID = 0L;
    private static final long IMPLIED_MATCH_SET_ID = -1L;
    private static final String PROPERTY_TABLE_NAME = "PropertyTable";
    private static final String DB_VERSION_PROPERTY_NAME = "DB_VERSION";
    private static final int DB_VERSION = 2;
    private static final int UPGRADE_REQUIRED_BEFORE_VERSION = 1;
    private VTMatchSetTableDBAdapter matchSetTableAdapter;
    private AssociationDatabaseManager associationManager;
    private VTMatchTagDBAdapter matchTagAdapter;
    private DBObjectCache<VTMatchTagDB> tagCache = new DBObjectCache(10);
    private Program sourceProgram;
    private Program destinationProgram;
    private List<VTMatchSetDB> matchSets = new CopyOnWriteArrayList<VTMatchSetDB>();
    private VTMatchSet manualMatchSet;
    private VTMatchSet impliedMatchSet;
    private boolean changeSetsModified = false;
    private Table propertyTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VTSessionDB createVTSession(String name, Program sourceProgram, Program destinationProgram, Object consumer) throws IOException {
        VTSessionDB session = new VTSessionDB(new DBHandle(), consumer);
        int ID = session.startTransaction("Constructing New Version Tracking Match Set");
        try {
            session.propertyTable = session.dbh.createTable(PROPERTY_TABLE_NAME, SCHEMA);
            session.matchSetTableAdapter = VTMatchSetTableDBAdapter.createAdapter(session.dbh);
            session.associationManager = AssociationDatabaseManager.createAssociationManager(session.dbh, session);
            session.matchTagAdapter = VTMatchTagDBAdapter.createAdapter(session.dbh);
            session.initializePrograms(sourceProgram, destinationProgram);
            session.createMatchSet(new ManualMatchProgramCorrelator(sourceProgram, destinationProgram), 0L);
            session.createMatchSet(new ImpliedMatchProgramCorrelator(sourceProgram, destinationProgram), -1L);
            session.updateVersion();
        }
        finally {
            session.endTransaction(ID, true);
        }
        try {
            session.addSynchronizedDomainObject((DomainObject)destinationProgram);
        }
        catch (Exception e) {
            session.close();
            throw new RuntimeException(e.getMessage(), e);
        }
        return session;
    }

    private void updateVersion() throws IOException {
        DBRecord record = SCHEMA.createRecord((Field)new StringField(DB_VERSION_PROPERTY_NAME));
        record.setString(0, Integer.toString(2));
        this.propertyTable.putRecord(record);
    }

    public static VTSessionDB getVTSession(DBHandle dbHandle, OpenMode openMode, Object consumer, TaskMonitor monitor) throws VersionException, IOException {
        VTSessionDB session = new VTSessionDB(dbHandle, consumer);
        int storedVersion = session.getVersion();
        if (storedVersion > 2) {
            throw new VersionException(2, false);
        }
        if (storedVersion < 1) {
            throw new VersionException("Version Tracking Sessions do not support schema upgrades.");
        }
        session.matchSetTableAdapter = VTMatchSetTableDBAdapter.getAdapter(session.getDBHandle(), openMode, monitor);
        session.associationManager = AssociationDatabaseManager.getAssociationManager(dbHandle, session, openMode, monitor);
        session.matchTagAdapter = VTMatchTagDBAdapter.getAdapter(session.getDBHandle(), openMode, monitor);
        session.loadMatchSets(openMode, monitor);
        return session;
    }

    private void initializePrograms(Program sourceProgram, Program destinationProgram) {
        this.sourceProgram = sourceProgram;
        this.destinationProgram = destinationProgram;
        sourceProgram.addConsumer((Object)this);
        destinationProgram.addConsumer((Object)this);
        Options properties = this.getOptions(PROGRAM_ID_PROPERTYLIST_NAME);
        DomainFile sourceDomainFile = sourceProgram.getDomainFile();
        properties.setString(SOURCE_PROGRAM_ID_PROPERTY_KEY, sourceDomainFile.getFileID());
        DomainFile destinationDomainFile = destinationProgram.getDomainFile();
        properties.setString(DESTINATION_PROGRAM_ID_PROPERTY_KEY, destinationDomainFile.getFileID());
    }

    @Override
    public void updateDestinationProgram(Program newProgram) {
        try {
            this.releaseSynchronizedDomainObject();
        }
        catch (LockException e) {
            Msg.showError((Object)this, null, (String)"Error releasing synchronization to old program", (Object)((Object)e));
        }
        this.destinationProgram.release((Object)this);
        this.destinationProgram = newProgram;
        this.destinationProgram.addConsumer((Object)this);
        try {
            this.addSynchronizedDomainObject((DomainObject)this.destinationProgram);
        }
        catch (Exception e) {
            this.sourceProgram.release((Object)this);
            this.destinationProgram.release((Object)this);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateSourceProgram(Program newProgram) {
        this.sourceProgram.release((Object)this);
        this.sourceProgram = newProgram;
        this.sourceProgram.addConsumer((Object)this);
    }

    public String getSourceProgramID() {
        Options properties = this.getOptions(PROGRAM_ID_PROPERTYLIST_NAME);
        return properties.getString(SOURCE_PROGRAM_ID_PROPERTY_KEY, "");
    }

    public String getDestinationProgramID() {
        Options properties = this.getOptions(PROGRAM_ID_PROPERTYLIST_NAME);
        return properties.getString(DESTINATION_PROGRAM_ID_PROPERTY_KEY, "");
    }

    private VTSessionDB(DBHandle dbHandle, Object consumer) {
        super(dbHandle, UNUSED_DEFAULT_NAME, 500, consumer);
        this.propertyTable = dbHandle.getTable(PROPERTY_TABLE_NAME);
    }

    public int getVersion() throws IOException {
        if (this.propertyTable == null) {
            return 0;
        }
        DBRecord record = this.propertyTable.getRecord((Field)new StringField(DB_VERSION_PROPERTY_NAME));
        if (record != null) {
            String s = record.getString(0);
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected void setDomainFile(DomainFile df) {
        super.setDomainFile(df);
        DomainFolder parent = df.getParent();
        if (parent == null) {
            return;
        }
        if (this.sourceProgram != null) {
            return;
        }
        ProjectData projectData = parent.getProjectData();
        String sourceProgramID = this.getSourceProgramID();
        String destinationProgramID = this.getDestinationProgramID();
        DomainFile sourceFile = projectData.getFileByID(sourceProgramID);
        DomainFile destinationFile = projectData.getFileByID(destinationProgramID);
        if (sourceFile == null) {
            throw new RuntimeException("Source program is missing for this Version Tracking Session!");
        }
        if (destinationFile == null) {
            throw new RuntimeException("Destination program is missing for this Version Tracking Session!");
        }
        this.sourceProgram = this.openProgram(sourceFile, true);
        if (this.sourceProgram != null) {
            this.destinationProgram = this.openProgram(destinationFile, false);
        }
        if (this.sourceProgram == null || this.destinationProgram == null) {
            StringBuilder buffer = new StringBuilder("Session not opened because one or both programs did not open.\n");
            if (this.sourceProgram != null) {
                this.sourceProgram.release((Object)this);
                this.sourceProgram = null;
            } else {
                buffer.append("\tUnable to open source program \"" + sourceFile + "\"\n");
            }
            if (this.destinationProgram != null) {
                this.destinationProgram.release((Object)this);
                this.destinationProgram = null;
            } else {
                buffer.append("\tUnable to open destination program \"" + destinationFile + "\"\n");
            }
            throw new RuntimeException(buffer.toString());
        }
        this.associationManager.sessionInitialized();
        try {
            this.addSynchronizedDomainObject((DomainObject)this.destinationProgram);
        }
        catch (Exception e) {
            this.sourceProgram.release((Object)this);
            this.destinationProgram.release((Object)this);
            throw new RuntimeException(e.getMessage());
        }
    }

    private Program openProgram(DomainFile domainFile, boolean isSource) {
        OpenProgramTask openTask = new OpenProgramTask(domainFile, (Object)this);
        String type = isSource ? "(source program)" : "(destination program)";
        openTask.setOpenPromptText("Open " + type);
        TaskLauncher.launch((Task)openTask);
        OpenProgramRequest openProgram = openTask.getOpenProgram();
        return openProgram != null ? openProgram.getProgram() : null;
    }

    public void release(Object consumer) {
        super.release(consumer);
        if (this.isClosed()) {
            if (this.sourceProgram != null) {
                this.sourceProgram.release((Object)this);
                this.sourceProgram = null;
            }
            if (this.destinationProgram != null) {
                this.destinationProgram.release((Object)this);
                this.destinationProgram = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache(boolean all) {
        this.lock.acquire();
        try {
            super.clearCache(all);
            this.associationManager.invalidateCache();
            this.tagCache.invalidate();
            ArrayList<VTMatchSetDB> temp = new ArrayList<VTMatchSetDB>();
            for (VTMatchSetDB matchSet : this.matchSets) {
                if (matchSet.isInvalid()) continue;
                matchSet.invalidateCache();
                temp.add(matchSet);
            }
            this.matchSets.retainAll(temp);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void save() throws IOException {
        try {
            this.save(DESTINATION_PROGRAM_ID_PROPERTY_KEY, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void loadMatchSets(OpenMode openMode, TaskMonitor monitor) throws IOException, VersionException {
        RecordIterator recordIterator = this.matchSetTableAdapter.getRecords();
        while (recordIterator.hasNext()) {
            DBRecord record = recordIterator.next();
            this.matchSets.add(VTMatchSetDB.getMatchSetDB(record, this, this.getDBHandle(), openMode, monitor, this.lock));
        }
    }

    @Override
    public Program getSourceProgram() {
        return this.sourceProgram;
    }

    @Override
    public Program getDestinationProgram() {
        return this.destinationProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VTMatchSet createMatchSet(VTProgramCorrelator correlator) {
        try {
            this.lock.acquire();
            long id = this.matchSetTableAdapter.getNextMatchSetID();
            VTMatchSet vTMatchSet = this.createMatchSet(correlator, id);
            return vTMatchSet;
        }
        finally {
            this.lock.release();
        }
    }

    private VTMatchSet createMatchSet(VTProgramCorrelator correlator, long id) {
        try {
            DBRecord record = this.matchSetTableAdapter.createMatchSetRecord(id, correlator);
            VTMatchSetDB matchSet = VTMatchSetDB.createMatchSetDB(record, this, this.getDBHandle(), this.lock);
            this.matchSets.add(matchSet);
            this.changeSetsModified = true;
            this.setObjectChanged(1010, matchSet, null, matchSet);
            return matchSet;
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    DBRecord getMatchSetRecord(long key) {
        try {
            return this.matchSetTableAdapter.getRecord(key);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    long getLongFromSourceAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("You must always have a valid source address!");
        }
        AddressMap addressMap = this.sourceProgram.getAddressMap();
        return addressMap.getKey(address, false);
    }

    long getLongFromDestinationAddress(Address address) {
        if (address == null) {
            return -1L;
        }
        AddressMap addressMap = this.destinationProgram.getAddressMap();
        return addressMap.getKey(address, false);
    }

    Address getSourceAddressFromLong(long value) {
        if (-1L == value) {
            throw new AssertException("How can we have an invalid address for the source?!?");
        }
        AddressMap addressMap = this.sourceProgram.getAddressMap();
        return addressMap.decodeAddress(value);
    }

    Address getDestinationAddressFromLong(long value) {
        if (-1L == value) {
            return null;
        }
        AddressMap addressMap = this.destinationProgram.getAddressMap();
        return addressMap.decodeAddress(value);
    }

    @Override
    public List<VTMatchSet> getMatchSets() {
        return new ArrayList<VTMatchSet>(this.matchSets);
    }

    AddressSet getSourceAddressSet(DBRecord record) throws IOException {
        return this.matchSetTableAdapter.getSourceAddressSet(record, this.sourceProgram.getAddressMap());
    }

    AddressSet getDestinationAddressSet(DBRecord record) throws IOException {
        return this.matchSetTableAdapter.getDestinationAddressSet(record, this.destinationProgram.getAddressMap());
    }

    @Override
    public VTAssociationManager getAssociationManager() {
        return this.associationManager;
    }

    public AssociationDatabaseManager getAssociationManagerDBM() {
        return this.associationManager;
    }

    @Override
    public String getName() {
        return this.getDomainFile().getName();
    }

    public String getDescription() {
        return "Version Tracking Results";
    }

    public boolean isChangeable() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setChanged(int type, Object oldValue, Object newValue) {
        this.changed = true;
        this.fireEvent(new VersionTrackingChangeRecord(type, null, oldValue, newValue));
    }

    @Override
    public List<VTMatch> getMatches(VTAssociation association) {
        ArrayList<VTMatch> matches = new ArrayList<VTMatch>();
        for (VTMatchSet vTMatchSet : this.matchSets) {
            matches.addAll(vTMatchSet.getMatches(association));
        }
        return matches;
    }

    @Override
    public void setObjectChanged(int type, Object affectedObject, Object oldValue, Object newValue) {
        this.changed = true;
        this.fireEvent(new VersionTrackingChangeRecord(type, affectedObject, oldValue, newValue));
    }

    @Override
    public VTMatchSet getManualMatchSet() {
        if (this.manualMatchSet == null) {
            this.manualMatchSet = this.findMatchSet(ManualMatchProgramCorrelator.class.getName());
        }
        return this.manualMatchSet;
    }

    @Override
    public VTMatchSet getImpliedMatchSet() {
        if (this.impliedMatchSet == null) {
            this.impliedMatchSet = this.findMatchSet(ImpliedMatchProgramCorrelator.class.getName());
        }
        return this.impliedMatchSet;
    }

    private VTMatchSet findMatchSet(String correlatorClassName) {
        for (VTMatchSet vTMatchSet : this.matchSets) {
            VTProgramCorrelatorInfo info = vTMatchSet.getProgramCorrelatorInfo();
            String matchSetCorrelatorClassName = info.getCorrelatorClassName();
            if (!correlatorClassName.equals(matchSetCorrelatorClassName)) continue;
            return vTMatchSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMatchTag(VTMatchTag tag) {
        String tagName = tag.getName();
        try {
            this.lock.acquire();
            VTMatchTagDB tagDB = this.getMatchTagDB(tagName);
            if (tagDB == null) {
                return;
            }
            long key = tagDB.getKey();
            this.tagCache.delete(key);
            this.matchTagAdapter.deleteRecord(key);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        this.setObjectChanged(1041, this, tagName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VTMatchTagDB createMatchTag(String tagName) {
        VTMatchTagDB matchTag = null;
        try {
            this.lock.acquire();
            matchTag = this.getMatchTagDB(tagName);
            if (matchTag != null) {
                VTMatchTagDB vTMatchTagDB = matchTag;
                return vTMatchTagDB;
            }
            DBRecord record = this.matchTagAdapter.insertRecord(tagName);
            matchTag = new VTMatchTagDB(this, this.tagCache, record);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        this.setObjectChanged(1040, matchTag, null, matchTag);
        return matchTag;
    }

    private VTMatchTagDB getMatchTagDB(String tagName) {
        Set<VTMatchTag> matchTags = this.getMatchTags();
        for (VTMatchTag matchTag : matchTags) {
            if (!matchTag.getName().equals(tagName)) continue;
            return (VTMatchTagDB)matchTag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<VTMatchTag> getMatchTags() {
        HashSet<VTMatchTag> tags = new HashSet<VTMatchTag>();
        try {
            this.lock.acquire();
            RecordIterator records = this.matchTagAdapter.getRecords();
            while (records.hasNext()) {
                DBRecord record = records.next();
                tags.add(this.getMatchTagNew(record));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VTMatchTagDB getMatchTagNew(DBRecord record) {
        if (record == null) {
            throw new AssertException("How can we have a null record?!!!");
        }
        try {
            this.lock.acquire();
            VTMatchTagDB matchTagDB = (VTMatchTagDB)this.tagCache.get(record);
            if (matchTagDB == null) {
                matchTagDB = new VTMatchTagDB(this, this.tagCache, record);
            }
            VTMatchTagDB vTMatchTagDB = matchTagDB;
            return vTMatchTagDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VTMatchTag getMatchTag(long key) {
        this.lock.acquire();
        try {
            VTMatchTagDB matchTagDB = (VTMatchTagDB)this.tagCache.get(key);
            if (matchTagDB != null) {
                VTMatchTagDB vTMatchTagDB = matchTagDB;
                return vTMatchTagDB;
            }
            DBRecord record = this.matchTagAdapter.getRecord(key);
            if (record != null) {
                VTMatchTagDB vTMatchTagDB = new VTMatchTagDB(this, this.tagCache, record);
                return vTMatchTagDB;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return VTMatchTag.UNTAGGED;
    }

    DBRecord getTagRecord(long key) throws IOException {
        return this.matchTagAdapter.getRecord(key);
    }

    public VTMatchTagDB getOrCreateMatchTagDB(VTMatchTag tag) {
        if (tag == null) {
            return null;
        }
        if (tag == VTMatchTag.UNTAGGED) {
            return null;
        }
        String tagName = tag.getName();
        return this.createMatchTag(tagName);
    }

    public void endTransaction(int transactionID, boolean commit) {
        TransactionInfo transaction = this.getCurrentTransactionInfo();
        super.endTransaction(transactionID, commit);
        if (this.changeSetsModified && transaction.getStatus() == TransactionInfo.Status.COMMITTED) {
            this.changeSetsModified = false;
        }
    }

    @Override
    public void addAssociationHook(AssociationHook hook) {
        this.associationManager.addAssociationHook(hook);
    }

    @Override
    public void removeAssociationHook(AssociationHook hook) {
        this.associationManager.removeAssociationHook(hook);
    }

    protected void close() {
        this.associationManager.dispose();
        super.close();
    }
}

