/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.util.AddressCorrelation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

public class LinearFunctionAddressCorrelation
implements AddressCorrelation {
    public static final String NAME = "LinearFunctionAddressCorrelation";
    private Map<Address, AddressRange> cachedForwardAddressMap;
    private final Function sourceFunction;
    private final Function destinationFunction;

    LinearFunctionAddressCorrelation(Function sourceFunction, Function destinationFunction) {
        this.sourceFunction = sourceFunction;
        this.destinationFunction = destinationFunction;
    }

    public String getName() {
        return NAME;
    }

    public AddressRange getCorrelatedDestinationRange(Address sourceAddress, TaskMonitor monitor) throws CancelledException {
        this.initialize(monitor);
        AddressRange toRange = this.cachedForwardAddressMap.get(sourceAddress);
        if (toRange == null) {
            double percentOffset = this.findPercentageFromFunctionStart(sourceAddress);
            Address destinationAddress = this.getDestinationAddress(percentOffset);
            toRange = new AddressRangeImpl(destinationAddress, destinationAddress);
        }
        return toRange;
    }

    private void initialize(TaskMonitor monitor) {
        if (this.cachedForwardAddressMap == null) {
            this.cachedForwardAddressMap = new HashMap<Address, AddressRange>();
            this.computeParamCorrelation();
        }
    }

    private double findPercentageFromFunctionStart(Address address) {
        AddressSetView srcBody = this.sourceFunction.getBody();
        long accumulatedLength = 0L;
        for (AddressRange range : srcBody) {
            if (range.getMaxAddress().compareTo((Object)address) < 0) {
                accumulatedLength += range.getLength();
                continue;
            }
            if (!range.contains(address)) break;
            accumulatedLength += address.subtract(range.getMinAddress());
            break;
        }
        double percentOffset = (double)accumulatedLength / (double)srcBody.getNumAddresses();
        return percentOffset;
    }

    private Address getDestinationAddress(double percentOffset) {
        AddressSetView srcBody = this.destinationFunction.getBody();
        long offset = (long)(percentOffset * (double)srcBody.getNumAddresses() + 0.5);
        AddressRangeIterator addressRanges = srcBody.getAddressRanges();
        while (addressRanges.hasNext()) {
            AddressRange addressRange = (AddressRange)addressRanges.next();
            long rangeLength = addressRange.getLength();
            if (offset < rangeLength) {
                Address address = addressRange.getMinAddress().add(offset);
                return address;
            }
            offset -= rangeLength;
        }
        return srcBody.getMaxAddress();
    }

    private void computeParamCorrelation() {
        Parameter[] destinationParameters;
        Parameter[] sourceParameters = this.sourceFunction.getParameters();
        if (sourceParameters.length != (destinationParameters = this.destinationFunction.getParameters()).length) {
            return;
        }
        HashMap<Address, AddressRangeImpl> map = new HashMap<Address, AddressRangeImpl>();
        for (int i = 0; i < sourceParameters.length; ++i) {
            VariableStorage destParamStorage;
            Parameter sourceParameter = sourceParameters[i];
            Parameter destinationParameter = destinationParameters[i];
            if (!sourceParameter.isValid() || !destinationParameter.isValid()) {
                return;
            }
            VariableStorage sourceParamStorage = sourceParameter.getVariableStorage();
            if (!sourceParamStorage.equals((Object)(destParamStorage = destinationParameter.getVariableStorage()))) {
                return;
            }
            Address dest = sourceParamStorage.getMinAddress();
            Address src = destParamStorage.getMinAddress();
            map.put(src, new AddressRangeImpl(dest, dest));
        }
        this.cachedForwardAddressMap.putAll(map);
    }
}

