/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt;

import ghidra.app.script.GhidraScript;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class GhidraVersionTrackingScript
extends GhidraScript {
    protected VTSession vtSession;
    protected Program sourceProgram;
    protected Program destinationProgram;
    private int transactionID;

    public void createVersionTrackingSession(String sourceProgramPath, String destinationProgramPath) throws Exception {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to open a new session with one already open!");
        }
        this.sourceProgram = this.openProgram(sourceProgramPath);
        this.destinationProgram = this.openProgram(destinationProgramPath);
        this.createVersionTrackingSession("New Session", this.sourceProgram, this.destinationProgram);
    }

    public void createVersionTrackingSession(String name, Program source, Program destination) throws Exception {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to create a new session with one already open!");
        }
        this.sourceProgram = source;
        this.destinationProgram = destination;
        if (!this.sourceProgram.isUsedBy((Object)this)) {
            this.sourceProgram.addConsumer((Object)this);
        }
        if (!this.destinationProgram.isUsedBy((Object)this)) {
            this.destinationProgram.addConsumer((Object)this);
        }
        this.vtSession = VTSessionDB.createVTSession(name, this.sourceProgram, this.destinationProgram, (Object)this);
        this.transactionID = this.vtSession.startTransaction("VT Script");
    }

    public void openVersionTrackingSession(String path) throws Exception {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to open a session with one already open!");
        }
        if (this.state.getProject() == null) {
            throw new RuntimeException("No project open.");
        }
        DomainFile file = this.state.getProject().getProjectData().getFile(path);
        this.vtSession = (VTSessionDB)file.getDomainObject((Object)this, true, true, this.monitor);
        this.sourceProgram = this.vtSession.getSourceProgram();
        this.destinationProgram = this.vtSession.getDestinationProgram();
        if (!this.sourceProgram.isUsedBy((Object)this)) {
            this.sourceProgram.addConsumer((Object)this);
        }
        if (!this.destinationProgram.isUsedBy((Object)this)) {
            this.destinationProgram.addConsumer((Object)this);
        }
        this.transactionID = this.vtSession.startTransaction("VT Script");
    }

    public void saveVersionTrackingSession() throws IOException {
        this.vtSession.endTransaction(this.transactionID, true);
        this.vtSession.save();
        this.transactionID = this.vtSession.startTransaction("VT Script");
    }

    public void saveSessionAs(String path, String name) throws Exception {
        DomainFolder folder = this.state.getProject().getProjectData().getFolder(path);
        folder.createFile(name, (DomainObject)this.vtSession, this.monitor);
        this.vtSession.setName(name);
    }

    public void cleanup(boolean success) {
        this.closeVersionTrackingSession();
        if (this.destinationProgram != null) {
            this.closeProgram(this.destinationProgram);
        }
        if (this.sourceProgram != null) {
            this.closeProgram(this.sourceProgram);
        }
        this.sourceProgram = null;
        this.destinationProgram = null;
    }

    public void closeVersionTrackingSession() {
        if (this.vtSession != null) {
            this.vtSession.endTransaction(this.transactionID, true);
            this.vtSession.release((Object)this);
        }
    }

    public Program openProgram(String path) throws VersionException, CancelledException, IOException {
        if (this.state.getProject() == null) {
            throw new RuntimeException("No project open.");
        }
        DomainFile file = this.state.getProject().getProjectData().getFile(path);
        return (Program)file.getDomainObject((Object)this, true, true, this.monitor);
    }

    public void closeProgram(Program program) {
        program.release((Object)this);
    }

    public Set<String> getSourceFunctions() {
        if (this.vtSession == null) {
            throw new RuntimeException("You must have an open vt session");
        }
        return this.getFunctionNames(this.vtSession.getSourceProgram());
    }

    public Set<String> getDestinationFunctions() {
        if (this.vtSession == null) {
            throw new RuntimeException("You must have an open vt session");
        }
        return this.getFunctionNames(this.vtSession.getSourceProgram());
    }

    private Set<String> getFunctionNames(Program program) {
        HashSet<String> functionNames = new HashSet<String>();
        FunctionIterator functions = program.getFunctionManager().getFunctions(true);
        for (Function function : functions) {
            functionNames.add(function.getName());
        }
        return functionNames;
    }

    public List<String> getProgramCorrelators() {
        ArrayList<String> correlators = new ArrayList<String>();
        List<VTProgramCorrelatorFactory> generateList = GhidraVersionTrackingScript.getVTProgramCorrelatorFactory();
        for (VTProgramCorrelatorFactory vtProgramCorrelatorFactory : generateList) {
            correlators.add(vtProgramCorrelatorFactory.getName());
        }
        return correlators;
    }

    public void runCorrelator(String name) throws CancelledException {
        if (this.vtSession == null) {
            throw new RuntimeException("You must have an open vt session to run a correlator");
        }
        VTProgramCorrelatorFactory correlatorFactory = this.getCorrelatorFactory(name);
        VTProgramCorrelator correlator = correlatorFactory.createCorrelator(this.sourceProgram, this.sourceProgram.getMemory().getLoadedAndInitializedAddressSet(), this.destinationProgram, this.destinationProgram.getMemory().getLoadedAndInitializedAddressSet(), new VTOptions("dummy"));
        correlator.correlate(this.vtSession, this.monitor);
    }

    public Collection<VTMatch> getMatchesFromLastRunCorrelator() {
        List<VTMatchSet> matchSets = this.vtSession.getMatchSets();
        VTMatchSet last = matchSets.get(matchSets.size() - 1);
        return last.getMatches();
    }

    public Function getSourceFunction(VTMatch vtMatch) {
        VTAssociation association = vtMatch.getAssociation();
        Program source = this.vtSession.getSourceProgram();
        FunctionManager functionManager = source.getFunctionManager();
        return functionManager.getFunctionAt(association.getSourceAddress());
    }

    public Function getDestinationFunction(VTMatch vtMatch) {
        VTAssociation association = vtMatch.getAssociation();
        Program destination = this.vtSession.getDestinationProgram();
        FunctionManager functionManager = destination.getFunctionManager();
        return functionManager.getFunctionAt(association.getDestinationAddress());
    }

    private VTProgramCorrelatorFactory getCorrelatorFactory(String name) {
        List<VTProgramCorrelatorFactory> generateList = GhidraVersionTrackingScript.getVTProgramCorrelatorFactory();
        for (VTProgramCorrelatorFactory vtProgramCorrelatorFactory : generateList) {
            if (!vtProgramCorrelatorFactory.getName().equals(name)) continue;
            return vtProgramCorrelatorFactory;
        }
        return null;
    }

    private static List<VTProgramCorrelatorFactory> getVTProgramCorrelatorFactory() {
        return ClassSearcher.getInstances(VTProgramCorrelatorFactory.class);
    }
}

