/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator;

import ghidra.app.emulator.DefaultEmulator;
import ghidra.app.emulator.Emulator;
import ghidra.app.emulator.EmulatorConfiguration;
import ghidra.app.emulator.MemoryAccessFilter;
import ghidra.app.emulator.memory.EmulatorLoadData;
import ghidra.app.emulator.memory.MemoryLoadImage;
import ghidra.app.emulator.memory.ProgramMappedLoadImage;
import ghidra.app.emulator.memory.ProgramMappedMemory;
import ghidra.app.emulator.state.DumpMiscState;
import ghidra.app.emulator.state.RegisterState;
import ghidra.framework.store.LockException;
import ghidra.pcode.emulate.BreakCallBack;
import ghidra.pcode.emulate.EmulateExecutionState;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class EmulatorHelper
implements MemoryFaultHandler,
EmulatorConfiguration {
    private final Program program;
    private final Emulator emulator;
    private Register stackPtrReg;
    private AddressSpace stackMemorySpace;
    private String lastError;
    private MemoryWriteTracker memoryWriteTracker;
    private MemoryFaultHandler faultHandler;
    private DataConverter converter;
    private BreakCallBack addressBreak = new BreakCallBack(){

        @Override
        public boolean addressCallback(Address addr) {
            EmulatorHelper.this.emulator.setHalt(true);
            return true;
        }
    };

    public EmulatorHelper(Program program) {
        this.program = program;
        this.stackPtrReg = program.getCompilerSpec().getStackPointer();
        this.stackMemorySpace = program.getCompilerSpec().getStackBaseSpace();
        this.emulator = this.newEmulator();
        this.converter = DataConverter.getInstance((boolean)program.getMemory().isBigEndian());
    }

    protected Emulator newEmulator() {
        return new DefaultEmulator(this);
    }

    public void dispose() {
        this.emulator.dispose();
        if (this.memoryWriteTracker != null) {
            this.memoryWriteTracker.dispose();
            this.memoryWriteTracker = null;
        }
    }

    @Override
    public MemoryFaultHandler getMemoryFaultHandler() {
        return this;
    }

    @Override
    public EmulatorLoadData getLoadData() {
        return new EmulatorLoadData(){

            @Override
            public MemoryLoadImage getMemoryLoadImage() {
                return new ProgramMappedLoadImage(new ProgramMappedMemory(EmulatorHelper.this.program, EmulatorHelper.this));
            }

            @Override
            public RegisterState getInitialRegisterState() {
                return new DumpMiscState(EmulatorHelper.this.getLanguage());
            }
        };
    }

    @Override
    public Language getLanguage() {
        return this.program.getLanguage();
    }

    public Program getProgram() {
        return this.program;
    }

    public Register getPCRegister() {
        return this.program.getLanguage().getProgramCounter();
    }

    public Register getStackPointerRegister() {
        return this.stackPtrReg;
    }

    public void setMemoryFaultHandler(MemoryFaultHandler handler) {
        this.faultHandler = handler;
    }

    public EmulateExecutionState getEmulateExecutionState() {
        return this.emulator.getEmulateExecutionState();
    }

    private Register getRegister(String regName) throws IllegalArgumentException {
        Register reg = this.program.getRegister(regName);
        if (reg == null) {
            throw new IllegalArgumentException("Undefined register: " + regName);
        }
        return reg;
    }

    public BigInteger readRegister(Register reg) {
        if (reg.isProcessorContext()) {
            RegisterValue contextRegisterValue = this.emulator.getContextRegisterValue();
            if (!reg.equals((Object)contextRegisterValue.getRegister())) {
                contextRegisterValue = contextRegisterValue.getRegisterValue(reg);
            }
            return contextRegisterValue.getSignedValueIgnoreMask();
        }
        if (reg.getName().equals(this.emulator.getPCRegisterName())) {
            return BigInteger.valueOf(this.emulator.getPC());
        }
        return this.emulator.getMemState().getBigInteger(reg);
    }

    public BigInteger readRegister(String regName) {
        Register reg = this.getRegister(regName);
        if (reg == null) {
            throw new IllegalArgumentException("Undefined register: " + regName);
        }
        return this.readRegister(reg);
    }

    public void writeRegister(Register reg, long value) {
        this.writeRegister(reg, BigInteger.valueOf(value));
    }

    public void writeRegister(String regName, long value) {
        this.writeRegister(regName, BigInteger.valueOf(value));
    }

    public void writeRegister(Register reg, BigInteger value) {
        if (reg.isProcessorContext()) {
            RegisterValue contextRegisterValue = new RegisterValue(reg, value);
            RegisterValue existingRegisterValue = this.emulator.getContextRegisterValue();
            if (!reg.equals((Object)existingRegisterValue.getRegister())) {
                contextRegisterValue = existingRegisterValue.combineValues(contextRegisterValue);
            }
            this.emulator.setContextRegisterValue(contextRegisterValue);
            return;
        }
        this.emulator.getMemState().setValue(reg, value);
        if (reg.getName().equals(this.emulator.getPCRegisterName())) {
            this.emulator.setExecuteAddress(value.longValue());
        }
    }

    public void writeRegister(String regName, BigInteger value) {
        Register reg = this.getRegister(regName);
        if (reg == null) {
            throw new IllegalArgumentException("Undefined register: " + regName);
        }
        this.writeRegister(reg, value);
    }

    public String readNullTerminatedString(Address addr, int maxLength) {
        int len = 0;
        byte[] bytes = new byte[maxLength];
        byte b = 0;
        while (len < maxLength && (b = this.readMemoryByte(addr)) != 0) {
            bytes[len++] = b;
            addr = addr.next();
        }
        Object str = new String(bytes, 0, len);
        if (b != 0) {
            str = (String)str + "...";
        }
        return str;
    }

    public byte readMemoryByte(Address addr) {
        byte[] value = this.readMemory(addr, 1);
        return value[0];
    }

    public byte[] readMemory(Address addr, int length) {
        byte[] res = new byte[length];
        int len = this.emulator.getMemState().getChunk(res, addr.getAddressSpace(), addr.getOffset(), length, false);
        if (len == 0) {
            Msg.error((Object)this, (Object)("Failed to read memory from Emulator at: " + addr));
            return null;
        }
        if (len < length) {
            Msg.error((Object)this, (Object)("Only " + len + " of " + length + " bytes read memory from Emulator at: " + addr));
        }
        return res;
    }

    public void writeMemory(Address addr, byte[] bytes) {
        this.emulator.getMemState().setChunk(bytes, addr.getAddressSpace(), addr.getOffset(), bytes.length);
    }

    public void writeMemoryValue(Address addr, int size, long value) {
        this.emulator.getMemState().setValue(addr.getAddressSpace(), addr.getOffset(), size, value);
    }

    public BigInteger readStackValue(int relativeOffset, int size, boolean signed) throws Exception {
        long offset = this.readRegister(this.stackPtrReg).longValue() + (long)relativeOffset;
        byte[] bytes = this.readMemory(this.stackMemorySpace.getAddress(offset), size);
        return this.converter.getBigInteger(bytes, size, signed);
    }

    public void writeStackValue(int relativeOffset, int size, long value) throws Exception {
        long offset = this.readRegister(this.stackPtrReg).longValue() + (long)relativeOffset;
        byte[] bytes = new byte[size];
        this.converter.getBytes(value, size, bytes, 0);
        this.writeMemory(this.stackMemorySpace.getAddress(offset), bytes);
    }

    public void writeStackValue(int relativeOffset, int size, BigInteger value) throws Exception {
        long offset = this.readRegister(this.stackPtrReg).longValue() + (long)relativeOffset;
        byte[] bytes = this.converter.getBytes(value, size);
        this.writeMemory(this.stackMemorySpace.getAddress(offset), bytes);
    }

    public void setBreakpoint(Address addr) {
        this.emulator.getBreakTable().registerAddressCallback(addr, this.addressBreak);
    }

    public void clearBreakpoint(Address addr) {
        this.emulator.getBreakTable().unregisterAddressCallback(addr);
    }

    public void setContextRegister(RegisterValue ctxRegValue) {
        this.emulator.setContextRegisterValue(ctxRegValue);
    }

    public void setContextRegister(Register ctxReg, BigInteger value) {
        this.emulator.setContextRegisterValue(new RegisterValue(ctxReg, value));
    }

    public RegisterValue getContextRegister() {
        return this.emulator.getContextRegisterValue();
    }

    public void registerCallOtherCallback(String pcodeOpName, BreakCallBack callback) {
        this.emulator.getBreakTable().registerPcodeCallback(pcodeOpName, callback);
    }

    public void registerDefaultCallOtherCallback(BreakCallBack callback) {
        this.emulator.getBreakTable().registerPcodeCallback("*", callback);
    }

    public void unregisterCallOtherCallback(String pcodeOpName) {
        this.emulator.getBreakTable().unregisterPcodeCallback(pcodeOpName);
    }

    public void unregisterDefaultCallOtherCallback() {
        this.emulator.getBreakTable().unregisterPcodeCallback("*");
    }

    public Address getExecutionAddress() {
        return this.emulator.getExecuteAddress();
    }

    public boolean run(Address addr, ProcessorContext context, TaskMonitor monitor) throws CancelledException {
        if (this.emulator.isExecuting()) {
            throw new IllegalStateException("Emulator is already running");
        }
        ProgramContext programContext = this.program.getProgramContext();
        Register baseContextRegister = programContext.getBaseContextRegister();
        RegisterValue contextRegValue = null;
        boolean mustSetContextReg = false;
        if (baseContextRegister != null && (contextRegValue = this.getContextRegister()) == null) {
            contextRegValue = programContext.getRegisterValue(baseContextRegister, addr);
            boolean bl = mustSetContextReg = contextRegValue != null;
        }
        if (context != null) {
            for (Register reg : context.getRegisters()) {
                if (!reg.isBaseRegister() || !context.hasValue(reg)) continue;
                RegisterValue registerValue = context.getRegisterValue(reg);
                if (reg.isProcessorContext()) {
                    contextRegValue = contextRegValue != null ? contextRegValue.combineValues(registerValue) : registerValue;
                    mustSetContextReg = true;
                    continue;
                }
                BigInteger value = registerValue.getUnsignedValueIgnoreMask();
                this.writeRegister(reg, value);
            }
        }
        long pcValue = addr.getAddressableWordOffset();
        this.emulator.setExecuteAddress(pcValue);
        if (mustSetContextReg) {
            this.setContextRegister(contextRegValue);
        }
        this.continueExecution(monitor);
        return this.emulator.isAtBreakpoint();
    }

    public synchronized boolean run(TaskMonitor monitor) throws CancelledException {
        if (this.emulator.isExecuting()) {
            throw new IllegalStateException("Emulator is already running");
        }
        this.continueExecution(monitor);
        return this.emulator.isAtBreakpoint();
    }

    private void continueExecution(TaskMonitor monitor) throws CancelledException {
        this.emulator.setHalt(false);
        do {
            this.executeInstruction(true, monitor);
        } while (!this.emulator.getHalt());
    }

    private void executeInstruction(boolean stopAtBreakpoint, TaskMonitor monitor) throws CancelledException {
        this.lastError = null;
        try {
            if (this.emulator.getLastExecuteAddress() == null) {
                this.setProcessorContext();
            }
            this.emulator.executeInstruction(stopAtBreakpoint, monitor);
        }
        catch (Throwable t) {
            this.lastError = t.getMessage();
            if (this.lastError == null) {
                this.lastError = t.toString();
            }
            this.emulator.setHalt(true);
            if (t instanceof CancelledException) {
                CancelledException ce = (CancelledException)t;
                throw ce;
            }
            Msg.error((Object)this, (Object)("Emulation failure at " + this.emulator.getExecuteAddress() + ": " + this.program.getName()), (Throwable)t);
        }
    }

    private void setProcessorContext() {
        RegisterValue contextRegisterValue = this.emulator.getContextRegisterValue();
        if (contextRegisterValue != null) {
            return;
        }
        Address executeAddress = this.emulator.getExecuteAddress();
        Instruction instructionAt = this.program.getListing().getInstructionAt(executeAddress);
        if (instructionAt != null) {
            RegisterValue disassemblyContext = instructionAt.getRegisterValue(instructionAt.getBaseContextRegister());
            this.emulator.setContextRegisterValue(disassemblyContext);
        }
    }

    public String getLastError() {
        return this.lastError;
    }

    public synchronized boolean step(TaskMonitor monitor) throws CancelledException {
        this.executeInstruction(true, monitor);
        return this.lastError == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBlock createMemoryBlockFromMemoryState(String name, final Address start, final int length, boolean overlay, TaskMonitor monitor) throws MemoryConflictException, AddressOverflowException, CancelledException, LockException, DuplicateNameException {
        MemoryBlock block;
        if (this.emulator.isExecuting()) {
            throw new IllegalStateException("Emulator must be paused to access memory state");
        }
        InputStream memStateStream = new InputStream(){
            private MemoryState memState;
            private byte[] buffer;
            private long nextBufferOffset;
            private int bytesRemaining;
            private int bufferPos;
            {
                this.memState = EmulatorHelper.this.emulator.getMemState();
                this.buffer = new byte[1024];
                this.nextBufferOffset = start.getOffset();
                this.bytesRemaining = length;
                this.bufferPos = this.buffer.length;
            }

            @Override
            public int read() throws IOException {
                if (this.bytesRemaining <= 0) {
                    return -1;
                }
                if (this.bufferPos == this.buffer.length) {
                    int size = Math.min(this.buffer.length, this.bytesRemaining);
                    this.memState.getChunk(this.buffer, start.getAddressSpace(), this.nextBufferOffset, size, false);
                    this.nextBufferOffset += (long)this.buffer.length;
                    this.bufferPos = 0;
                }
                byte b = this.buffer[this.bufferPos++];
                --this.bytesRemaining;
                return b;
            }
        };
        boolean success = false;
        int txId = this.program.startTransaction("Create Memory Block");
        try {
            block = this.program.getMemory().createInitializedBlock(name, start, memStateStream, (long)length, monitor, overlay);
            success = true;
        }
        finally {
            this.program.endTransaction(txId, success);
        }
        return block;
    }

    public void enableMemoryWriteTracking(boolean enable) {
        if (!enable) {
            if (this.memoryWriteTracker != null) {
                this.memoryWriteTracker.dispose();
                this.memoryWriteTracker = null;
            }
            return;
        }
        this.memoryWriteTracker = new MemoryWriteTracker();
        this.emulator.addMemoryAccessFilter(this.memoryWriteTracker);
    }

    public AddressSetView getTrackedMemoryWriteSet() {
        if (this.memoryWriteTracker != null) {
            return this.memoryWriteTracker.writeSet;
        }
        return null;
    }

    @Override
    public boolean unknownAddress(Address address, boolean write) {
        if (this.faultHandler != null) {
            return this.faultHandler.unknownAddress(address, write);
        }
        Address pc = this.emulator.getExecuteAddress();
        String access = write ? "written" : "read";
        Msg.warn((Object)this, (Object)("Unknown address " + access + " at " + pc + ": " + address));
        return false;
    }

    @Override
    public boolean uninitializedRead(Address address, int size, byte[] buf, int bufOffset) {
        if (this.faultHandler != null) {
            return this.faultHandler.uninitializedRead(address, size, buf, bufOffset);
        }
        if (this.emulator.getEmulateExecutionState() == EmulateExecutionState.INSTRUCTION_DECODE) {
            return false;
        }
        Address pc = this.emulator.getExecuteAddress();
        Register reg = this.program.getRegister(address, size);
        if (reg != null) {
            Msg.warn((Object)this, (Object)("Uninitialized register read at " + pc + ": " + reg));
            return true;
        }
        Msg.warn((Object)this, (Object)("Uninitialized memory read at " + pc + ": " + address.toString(true) + ":" + size));
        return true;
    }

    public Emulator getEmulator() {
        return this.emulator;
    }

    private class MemoryWriteTracker
    extends MemoryAccessFilter {
        AddressSet writeSet = new AddressSet();

        private MemoryWriteTracker() {
        }

        @Override
        protected void processRead(AddressSpace spc, long off, int size, byte[] values) {
        }

        @Override
        protected void processWrite(AddressSpace spc, long off, int size, byte[] values) {
            AddressRangeImpl range = new AddressRangeImpl(spc.getAddress(off), spc.getAddress(off + (long)size - 1L));
            this.writeSet.add((AddressRange)range);
        }
    }
}

