/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.connect.Connector;
import ghidra.dbg.jdi.model.JdiModelTargetConnectorContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Connector", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Description", type=String.class, required=true, fixed=true), @TargetAttributeType(name="Default Arguments", type=Object.class, required=true, fixed=true), @TargetAttributeType(name="Transport", type=Object.class, required=true, fixed=true), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetConnector
extends JdiModelTargetObjectImpl
implements JdiModelSelectableObject,
JdiModelTargetLauncher {
    protected final JdiModelTargetConnectorContainer connectors;
    protected final Connector cx;
    protected final TargetMethod.TargetParameterMap paramDescs;

    public JdiModelTargetConnector(JdiModelTargetConnectorContainer connectors, Connector cx, boolean isElement) {
        super(connectors, cx.name(), cx, isElement);
        this.connectors = connectors;
        this.cx = cx;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", cx.name(), "Description", cx.description(), "Default Arguments", cx.defaultArguments(), "Transport", cx.transport(), "_parameters", this.paramDescs), "Initialized");
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.cx == null ? super.getDisplay() : this.cx.name();
    }

    @Override
    public CompletableFuture<Void> setActive() {
        this.connectors.setDefaultConnector(this);
        return CompletableFuture.completedFuture(null);
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        return JdiModelTargetLauncher.getParameters(this.cx.defaultArguments());
    }

    public TargetMethod.TargetParameterMap getParameters() {
        return TargetMethod.getParameters((TargetObject)this);
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        Map<String, Connector.Argument> jdiArgs = JdiModelTargetLauncher.getArguments(this.cx.defaultArguments(), this.paramDescs, args);
        return this.getManager().addVM(this.cx, jdiArgs).thenApply(__ -> null);
    }
}

