/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import generic.stl.Pair;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.trees.SarifTreeWriter;
import sarif.managers.SarifMgr;

public class ProgramTreeSarifMgr
extends SarifMgr {
    public static String KEY = "PROGRAM_TREES";
    public static String SUBKEY = "ProgramTree";
    private List<String> fragmentNameList;
    private String treeName;
    private TaskMonitor monitor;

    ProgramTreeSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor m) throws CancelledException {
        this.monitor = m;
        this.listing.removeTree("Program Tree");
        this.processTree(result, result);
        return true;
    }

    private void processTree(Map<String, Object> result, Map<String, Object> result2) {
        this.treeName = (String)result.get("name");
        this.fragmentNameList = new ArrayList<String>();
        ProgramModule root = this.listing.getRootModule(this.treeName);
        try {
            try {
                String name;
                if (root == null) {
                    root = this.listing.createRootModule(this.treeName);
                }
                if ((name = root.getName()).endsWith(".sarif")) {
                    name = name.substring(0, name.indexOf(".sarif"));
                }
                if (name.endsWith(".json")) {
                    name = name.substring(0, name.indexOf(".json"));
                }
                root.setName(name);
            }
            catch (DuplicateNameException dne) {
                int oneUp = 1;
                while (true) {
                    try {
                        root = this.listing.createRootModule(this.treeName + "(" + oneUp + ")");
                    }
                    catch (DuplicateNameException e) {
                        ++oneUp;
                        continue;
                    }
                    break;
                }
                this.treeName = root.getTreeName();
            }
            List modules = (List)result.get("modules");
            for (Map m : modules) {
                this.monitor.checkCancelled();
                this.processModule(root, m);
            }
            List fragments = (List)result.get("fragments");
            for (Map f : fragments) {
                this.monitor.checkCancelled();
                this.processFragment(root, f);
            }
            this.removeEmptyFragments(root);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processModule(ProgramModule parent, Map<String, Object> module) {
        String name = (String)module.get("name");
        ProgramModule newModule = null;
        try {
            try {
                newModule = parent.createModule(name);
            }
            catch (DuplicateNameException dne) {
                newModule = this.listing.getModule(parent.getTreeName(), name);
                if (newModule == null) {
                    Msg.error((Object)this, (Object)("Duplicate name for " + name));
                    return;
                }
                parent.add(newModule);
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
        List modules = (List)module.get("modules");
        for (Map m : modules) {
            this.processModule(newModule, m);
        }
        List fragments = (List)module.get("fragments");
        for (Map f : fragments) {
            this.processFragment(newModule, f);
        }
        this.removeEmptyFragments(newModule);
    }

    private void processFragment(ProgramModule parent, Map<String, Object> fragment) {
        String name = (String)fragment.get("name");
        if (!this.fragmentNameList.contains(name)) {
            this.fragmentNameList.add(name);
        }
        ProgramFragment frag = null;
        try {
            frag = parent.createFragment(name);
        }
        catch (DuplicateNameException dne) {
            frag = this.listing.getFragment(parent.getTreeName(), name);
            try {
                parent.add(frag);
            }
            catch (DuplicateGroupException duplicateGroupException) {
                // empty catch block
            }
        }
        try {
            this.processFragmentRange(fragment, frag);
        }
        catch (NotFoundException e) {
            this.log.appendMsg(e.getMessage());
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processFragmentRange(Map<String, Object> fragment, ProgramFragment frag) throws AddressFormatException, NotFoundException {
        List ranges = (List)fragment.get("ranges");
        for (Map r : ranges) {
            if (this.monitor.isCancelled()) break;
            String startStr = (String)r.get("start");
            String endStr = (String)r.get("end");
            Address start = ProgramTreeSarifMgr.parseAddress(this.factory, startStr);
            Address end = ProgramTreeSarifMgr.parseAddress(this.factory, endStr);
            if (start == null || end == null) {
                throw new AddressFormatException("Incompatible Fragment Address Range: [" + startStr + "," + endStr + "]");
            }
            frag.move(start, end);
        }
    }

    private void removeEmptyFragments(ProgramModule module) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (group instanceof ProgramFragment) {
                String name = group.getName();
                if (this.fragmentNameList.contains(name)) continue;
                try {
                    module.removeChild(name);
                }
                catch (NotEmptyException e) {
                    this.log.appendMsg("Warning: Extra Program Tree fragment '" + name + "' did not exist in imported SARIF file");
                }
                continue;
            }
            this.removeEmptyFragments((ProgramModule)group);
        }
    }

    void write(JsonArray results, AddressSetView addrs, TaskMonitor m) throws IOException, CancelledException {
        String[] treeNames;
        this.monitor = m;
        m.setMessage("Writing PROGRAM TREES ...");
        ArrayList<Pair<String, ProgramModule>> request = new ArrayList<Pair<String, ProgramModule>>();
        for (String n : treeNames = this.listing.getTreeNames()) {
            if (m.isCancelled()) {
                throw new CancelledException();
            }
            ProgramModule root = this.listing.getRootModule(n);
            request.add((Pair<String, ProgramModule>)new Pair((Object)n, (Object)root));
        }
        ProgramTreeSarifMgr.writeAsSARIF(request, results);
    }

    public static void writeAsSARIF(List<Pair<String, ProgramModule>> request, JsonArray results) throws IOException {
        SarifTreeWriter writer = new SarifTreeWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

