/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ISF.AbstractIsfWriter;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.UnsignedInteger3DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.data.SarifDataTypeWriter;
import sarif.managers.DtParser;
import sarif.managers.SarifMgr;

public class DataTypesSarifMgr
extends SarifMgr {
    public static String KEY = "DATATYPE";
    private static final int MAX_PASSES = 10;
    private static final int DEFAULT_SIZE = 1;
    private static Map<String, DataType> foreignTypedefs = Map.of("ascii", CharDataType.dataType, "string1", PascalString255DataType.dataType, "string2", PascalStringDataType.dataType, "unicode2", PascalUnicodeDataType.dataType, "tbyte", LongDoubleDataType.dataType, "3byte", UnsignedInteger3DataType.dataType);
    private DataTypeManager dataManager;
    private DtParser dtParser;
    private Map<String, DataType> dataTypes = new HashMap<String, DataType>();
    private Map<String, Boolean> isPacked = new HashMap<String, Boolean>();
    private Map<String, Integer> packingValue = new HashMap<String, Integer>();

    public DataTypesSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.dataManager = program.getListing().getDataTypeManager();
    }

    @Override
    protected void readResults(List<Map<String, Object>> list, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        if (list != null) {
            boolean processedAll;
            monitor.setMessage("Processing " + this.key + "...");
            int pass = 0;
            block0: do {
                monitor.setMaximum((long)(list.size() * 10));
                monitor.checkCancelled();
                processedAll = true;
                for (Map<String, Object> result : list) {
                    if (monitor.isCancelled()) continue block0;
                    boolean res = this.read(result, options, monitor);
                    processedAll &= res;
                    monitor.increment();
                }
            } while (!processedAll && ++pass < 10);
        } else {
            monitor.setMessage("Skipping over " + this.key + " ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        try {
            this.dtParser = new DtParser(this.dataManager);
            boolean bl = this.process(result);
            return bl;
        }
        finally {
            this.dataManager.close();
            this.dtParser = null;
        }
    }

    private boolean process(Map<String, Object> result) {
        String name = (String)result.get("Message");
        try {
            if (name.equals("DT.Struct")) {
                return this.processStructure(result);
            }
            if (name.equals("DT.Union")) {
                return this.processUnion(result);
            }
            if (name.equals("DT.Enum")) {
                return this.processEnum(result);
            }
            if (name.equals("DT.Typedef")) {
                return this.processTypeDef(result);
            }
            if (name.equals("DT.TypedObject")) {
                return this.processTypedObject(result);
            }
            if (name.equals("DT.Builtin")) {
                return this.processBuiltin(result);
            }
            if (name.equals("DT.Function")) {
                return this.processFunctionDef(result);
            }
            this.log.appendMsg("Unrecognized datatype tag: " + name);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
        return true;
    }

    public void addDataType(String key, DataType dt) {
        Boolean packed = this.isPacked.get(key);
        if (packed != null) {
            Composite composite = (Composite)dt;
            composite.setPackingEnabled(packed.booleanValue());
            Integer packVal = this.packingValue.get(key);
            if (packVal != null) {
                composite.setExplicitPackingValue(packVal.intValue());
            }
        }
        this.dataTypes.put(key, dt);
        this.dataManager.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
    }

    private boolean processFunctionDef(Map<String, Object> result) throws InvalidInputException {
        boolean processedAll = true;
        String name = (String)result.get("name");
        CategoryPath path = this.getCategoryPath(result);
        FunctionDefinitionDataType fd = new FunctionDefinitionDataType(path, name, this.dataManager);
        this.processSettings(result, fd.getDefaultSettings());
        fd.setVarArgs(((Boolean)result.get("hasVarArgs")).booleanValue());
        fd.setNoReturn(((Boolean)result.get("hasNoReturn")).booleanValue());
        fd.setCallingConvention((String)result.get("callingConventionName"));
        this.dataTypes.put(this.getPath((DataType)fd), (DataType)fd);
        Map retType = (Map)result.get("retType");
        DataType returnType = this.findDataType(retType);
        if (returnType != null) {
            fd.setReturnType(returnType);
        }
        List params = (List)result.get("params");
        for (Map param : params) {
            processedAll &= this.processFunctionMembers(param, (FunctionDefinition)fd);
        }
        this.addDataType(this.getPath((DataType)fd), (DataType)fd);
        return processedAll;
    }

    private boolean processEnum(Map<String, Object> result) {
        String name = (String)result.get("name");
        String enuumComment = (String)result.get("comment");
        CategoryPath cp = this.getCategoryPath(result);
        int size = (int)((Double)result.get("size")).doubleValue();
        EnumDataType enuum = new EnumDataType(cp, name, size, this.dataManager);
        this.processSettings(result, enuum.getDefaultSettings());
        enuum.setDescription(enuumComment);
        Map constants = (Map)result.get("constants");
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            this.processEnumMembers(entry, (Enum)enuum);
        }
        this.addDataType(this.getPath((DataType)enuum), (DataType)enuum);
        return true;
    }

    private boolean processTypeDef(Map<String, Object> result) throws InvalidNameException, DuplicateNameException {
        String name = (String)result.get("name");
        Boolean isAutoNamed = (Boolean)result.get("autoNamed");
        String typeLoc = (String)result.get("typeLocation");
        CategoryPath cp = typeLoc == null ? CategoryPath.ROOT : new CategoryPath(typeLoc);
        DataType dt = this.findDataType(result);
        if (dt == null) {
            this.log.appendMsg(name + " NOT FOUND");
            return false;
        }
        int dtSize = dt.getLength();
        int size = (int)((Double)result.get("size")).doubleValue();
        if (size != -1 && size != dtSize) {
            this.log.appendMsg("SIZE=" + result.get("size") + " specified on type-def " + name + " does not agree with length of datatype " + dt.getPathName() + " (" + dtSize + ")");
        }
        cp = this.getCategoryPath(result);
        TypedefDataType td = new TypedefDataType(cp, name, dt, this.dataManager);
        this.processSettings(result, td.getDefaultSettings());
        if (isAutoNamed != null && isAutoNamed.booleanValue()) {
            td.enableAutoNaming();
        }
        try {
            if (name.equals(dt.getPathName()) && dt instanceof TypeDef) {
                td = (TypeDef)dt;
            }
            td.setCategoryPath(cp);
            dt = td;
        }
        catch (DuplicateNameException e) {
            this.log.appendMsg("Unable to place typedef '" + name + "' in category '" + cp + "'");
        }
        this.addDataType(this.getPath((DataType)td), (DataType)td);
        return true;
    }

    private boolean processStructure(Map<String, Object> result) throws InvalidDataTypeException {
        String packing;
        Object alignmentMin;
        String name = (String)result.get("name");
        CategoryPath path = this.getCategoryPath(result);
        int size = 1;
        if (result.get("size") != null) {
            size = (int)((Double)result.get("size")).doubleValue();
        }
        StructureDataType struct = new StructureDataType(path, name, size, this.dataManager);
        this.processSettings(result, struct.getDefaultSettings());
        String comment = this.getRegularComment(result);
        if (comment != null) {
            struct.setDescription(comment);
        }
        if ((alignmentMin = result.get("explicitMinimumAlignment")) != null) {
            struct.setExplicitMinimumAlignment((int)((Double)alignmentMin).doubleValue());
        }
        if ((packing = (String)result.get("packed")) != null) {
            this.isPacked.put(this.getPath((DataType)struct), Boolean.valueOf(packing));
            Object epval = result.get("explicitPackingValue");
            if (epval != null) {
                this.packingValue.put(this.getPath((DataType)struct), (int)((Double)epval).doubleValue());
            }
        }
        this.dataTypes.put(this.getPath((DataType)struct), (DataType)struct);
        boolean processedAll = true;
        Map fields = (Map)result.get("fields");
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            processedAll &= this.processStructMembers(entry, (Structure)struct);
        }
        if (processedAll) {
            this.addDataType(this.getPath((DataType)struct), (DataType)struct);
        } else {
            this.dataTypes.put(this.getPath((DataType)struct), (DataType)struct);
        }
        return processedAll;
    }

    private boolean processUnion(Map<String, Object> result) throws InvalidDataTypeException {
        String packing;
        Object alignmentMin;
        String name = (String)result.get("name");
        CategoryPath path = this.getCategoryPath(result);
        String comment = this.getRegularComment(result);
        UnionDataType union = new UnionDataType(path, name);
        this.processSettings(result, union.getDefaultSettings());
        if (comment != null) {
            union.setDescription(comment);
        }
        if ((alignmentMin = result.get("explicitMinimumAlignment")) != null) {
            union.setExplicitMinimumAlignment((int)((Double)alignmentMin).doubleValue());
        }
        if ((packing = (String)result.get("packed")) != null) {
            this.isPacked.put(this.getPath((DataType)union), Boolean.valueOf(packing));
            Object epval = result.get("explicitPackingValue");
            if (epval != null) {
                this.packingValue.put(this.getPath((DataType)union), (int)((Double)epval).doubleValue());
            }
        }
        this.dataTypes.put(this.getPath((DataType)union), (DataType)union);
        boolean processedAll = true;
        Map fields = (Map)result.get("fields");
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            processedAll &= this.processUnionMembers(entry, (Union)union);
        }
        if (processedAll) {
            this.addDataType(this.getPath((DataType)union), (DataType)union);
        } else {
            this.dataTypes.put(this.getPath((DataType)union), (DataType)union);
        }
        return processedAll;
    }

    private boolean processTypedObject(Map<String, Object> result) {
        CategoryPath cp = new CategoryPath((String)result.get("typeLocation"));
        String kind = (String)result.get("kind");
        int size = (int)((Double)result.get("size")).doubleValue();
        Map type = (Map)result.get("type");
        DataType baseType = this.findDataType(type, cp);
        if (baseType != null) {
            if (kind.equals("pointer")) {
                PointerDataType p = new PointerDataType(baseType, size, this.dataManager);
                this.addDataType(this.getPath((DataType)p), (DataType)p);
                return true;
            }
            throw new RuntimeException("Unexpected baseType kind=" + kind);
        }
        return false;
    }

    private boolean processBuiltin(Map<String, Object> result) {
        String name = (String)result.get("name");
        CategoryPath cp = this.getCategoryPath(result);
        DataType dt = this.findDataType(result, cp);
        if (dt != null) {
            this.addDataType(this.getPath(cp, name), dt);
            return true;
        }
        return false;
    }

    private String getRegularComment(Map<String, Object> result) {
        return (String)result.get("comment");
    }

    private boolean processFunctionMembers(Map<String, Object> param, FunctionDefinition fn) {
        DataType dt = this.findDataType(param);
        if (dt != null) {
            int ordinal = (int)((Double)param.get("ordinal")).doubleValue();
            String name = (String)param.get("name");
            String comment = (String)param.get("comment");
            int size = dt.getLength();
            if (size <= 0) {
                size = (int)((Double)param.get("size")).doubleValue();
            }
            fn.replaceArgument(ordinal, name, dt, comment, SourceType.USER_DEFINED);
            return true;
        }
        return false;
    }

    private void processEnumMembers(Map.Entry<String, Object> entry, Enum enuum) {
        String entryName = entry.getKey();
        Long entryValue = (long)((Double)entry.getValue()).doubleValue();
        enuum.add(entryName, entryValue.longValue(), null);
    }

    private boolean processStructMembers(Map.Entry<String, Object> entry, Structure struct) throws InvalidDataTypeException {
        boolean processedAll = true;
        Map field = (Map)entry.getValue();
        int offset = (int)((Double)field.get("offset")).doubleValue();
        Map type = (Map)field.get("type");
        DataType memberDT = this.findDataType(type);
        if (memberDT != null) {
            Dynamic dynamicDT;
            this.processSettings(type, memberDT.getDefaultSettings());
            if (memberDT instanceof Dynamic ? !(dynamicDT = (Dynamic)memberDT).canSpecifyLength() : memberDT.getLength() <= 0) {
                return false;
            }
            String memberName = entry.getKey();
            Boolean noFieldName = (Boolean)field.get("hasNoFieldName");
            if (noFieldName != null && noFieldName.booleanValue()) {
                memberName = null;
            }
            String memberComment = (String)field.get("comment");
            int compSize = (int)((Double)field.get("length")).doubleValue();
            if (field.get("bitOffset") != null) {
                int bitOffset = (int)((Double)field.get("bitOffset")).doubleValue();
                int bitSize = (int)((Double)field.get("bitSize")).doubleValue();
                DataTypeComponent dtc = struct.insertBitFieldAt(offset, memberDT.getLength(), bitOffset, memberDT, bitSize, memberName, memberComment);
                this.processSettings(field, dtc.getDefaultSettings());
                return processedAll;
            }
            DataTypeComponent dtc = offset == struct.getLength() ? struct.add(memberDT, compSize, memberName, memberComment) : struct.replaceAtOffset(offset, memberDT, compSize, memberName, memberComment);
            this.processSettings(field, dtc.getDefaultSettings());
        } else {
            processedAll = type.get("kind").equals("pointer");
        }
        return processedAll;
    }

    private boolean processUnionMembers(Map.Entry<String, Object> entry, Union union) throws InvalidDataTypeException {
        Map type;
        DataType memberDT;
        boolean processedAll = true;
        Map member = (Map)entry.getValue();
        String memberName = entry.getKey();
        Boolean noFieldName = (Boolean)member.get("hasNoFieldName");
        if (noFieldName != null && noFieldName.booleanValue()) {
            memberName = null;
        }
        if ((memberDT = this.findDataType(type = (Map)member.get("type"))) != null) {
            this.processSettings(type, memberDT.getDefaultSettings());
            String memberComment = (String)member.get("comment");
            int dtSize = memberDT.getLength();
            if (member.get("bitSize") != null) {
                int bitSize = (int)((Double)member.get("bitSize")).doubleValue();
                union.addBitField(memberDT, bitSize, memberName, memberComment);
                return processedAll;
            }
            DataTypeComponent dtc = union.add(memberDT, dtSize, memberName, memberComment);
            this.processSettings(member, dtc.getDefaultSettings());
        }
        return processedAll;
    }

    private CategoryPath getCategoryPath(Map<String, Object> result) {
        String nameSpace = (String)result.get("location");
        CategoryPath cp = nameSpace == null ? CategoryPath.ROOT : new CategoryPath(nameSpace);
        return cp;
    }

    private void processSettings(Map<String, Object> result, Settings defaultSettings) {
        List settings = (List)result.get("settings");
        if (settings != null) {
            for (Map map : settings) {
                String settingName = (String)map.get("name");
                String settingValue = (String)map.get("value");
                if (map.get("kind").equals("long")) {
                    long val = 0L;
                    try {
                        val = Long.valueOf(settingValue);
                    }
                    catch (NumberFormatException nfe) {
                        Msg.error((Object)this, (Object)nfe);
                    }
                    if (settingName.equals("ptr_type")) continue;
                    defaultSettings.setLong(settingName, val);
                    continue;
                }
                defaultSettings.setString(settingName, settingValue);
            }
        }
    }

    private DataType findDataType(Map<String, Object> type) {
        Map subtype;
        String loc = (String)type.get("location");
        if (loc == null && (subtype = (Map)type.get("subtype")) != null) {
            loc = (String)subtype.get("location");
        }
        return this.findDataType(type, new CategoryPath(loc));
    }

    private DataType findDataType(Map<String, Object> type, CategoryPath cp) {
        String typeName;
        Map subtype;
        String kind = (String)type.get("kind");
        String name = (String)type.get("name");
        if (kind == null) {
            return null;
        }
        if (kind.equals("pointer") || kind.equals("array")) {
            DataType byName = this.findExistingDataType(cp, kind, name);
            if (byName != null) {
                if (byName instanceof FunctionDefinition) {
                    return new PointerDataType(byName, this.dataManager);
                }
                return byName;
            }
            Map subtype2 = (Map)type.get("subtype");
            if (subtype2 != null) {
                DataType base = this.findDataType(subtype2, cp);
                if (base == null) {
                    return null;
                }
                if (kind.equals("pointer")) {
                    return new PointerDataType(base, this.dataManager);
                }
                int count = (int)((Double)type.get("count")).doubleValue();
                return new ArrayDataType(base, count, base.getLength(), this.dataManager);
            }
        }
        if (name == null) {
            return null;
        }
        if (kind.equals("typedef")) {
            subtype = (Map)type.get("type");
            typeName = (String)type.get("typeName");
            if (typeName != null) {
                cp = new CategoryPath((String)type.get("typeLocation"));
                name = typeName;
            } else if (subtype != null) {
                DataType base = this.findDataType(subtype);
                if (base == null) {
                    return null;
                }
                return base;
            }
        }
        if (kind.equals("bitfield")) {
            subtype = (Map)type.get("type");
            typeName = (String)type.get("typeName");
            if (typeName != null) {
                cp = new CategoryPath((String)type.get("typeLocation"));
                name = typeName;
            } else if (subtype != null) {
                DataType base = this.findDataType(subtype);
                if (base == null) {
                    return null;
                }
                return base;
            }
        }
        return this.findExistingDataType(cp, kind, name);
    }

    private DataType findExistingDataType(CategoryPath cp, String kind, String name) {
        DataType dt = this.dtParser.parseDataType(name, cp, -1);
        if (dt == null && this.addForeignTypedefIfNeeded(name)) {
            dt = this.dtParser.parseDataType(name, cp, -1);
        }
        if (dt != null) {
            return dt;
        }
        dt = this.dataTypes.get(this.getPath(cp, name));
        if (dt == null && kind.equals("typedef")) {
            dt = this.dataTypes.get(cp + "/functions/" + name);
        }
        if (dt != null) {
            return dt;
        }
        return this.dataTypes.get("/" + name);
    }

    private boolean addForeignTypedefIfNeeded(String dtName) {
        DataType ourType;
        int ptrIndex = dtName.indexOf(42);
        int index = dtName.indexOf(91);
        String baseName = dtName.trim();
        if (index < 0 || index > ptrIndex) {
            index = ptrIndex;
        }
        if (index > 0) {
            baseName = dtName.substring(0, index).trim();
        }
        if ((ourType = foreignTypedefs.get(baseName)) != null && this.dataManager.getDataType("/" + baseName) == null) {
            TypedefDataType newTypedef = new TypedefDataType(CategoryPath.ROOT, baseName, ourType, this.dataManager);
            this.dataManager.resolve((DataType)newTypedef, null);
            return true;
        }
        return false;
    }

    private String getPath(DataType dt) {
        String displayName = dt.getPathName();
        Object path = dt.getCategoryPath().getPath();
        if (!((String)path).equals("/")) {
            path = (String)path + "/";
        }
        return (String)path + displayName;
    }

    private String getPath(CategoryPath cp, String displayName) {
        Object path = cp.getPath();
        if (!((String)path).equals("/")) {
            path = (String)path + "/";
        }
        return (String)path + displayName;
    }

    public void write(JsonArray results, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing DATA TYPES ...");
        ArrayList<DataType> dataTypeList = new ArrayList<DataType>();
        this.dataManager.getAllDataTypes(dataTypeList);
        DataTypesSarifMgr.writeAsSARIF(this.program, dataTypeList, results);
    }

    public static void writeAsSARIF(Program program, List<DataType> dataTypeList, JsonArray results) throws IOException {
        SarifDataTypeWriter writer = new SarifDataTypeWriter((DataTypeManager)program.getDataTypeManager(), dataTypeList, null);
        new TaskLauncher((Task)new SarifWriterTask("DataTypes", (AbstractIsfWriter)writer, results), null);
    }
}

