/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.run;

import com.contrastsecurity.sarif.Edge;
import com.contrastsecurity.sarif.Graph;
import com.contrastsecurity.sarif.Node;
import com.contrastsecurity.sarif.Run;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sarif.handlers.SarifRunHandler;
import sarif.model.SarifDataFrame;

public class SarifGraphRunHandler
extends SarifRunHandler {
    @Override
    public String getKey() {
        return "graphs";
    }

    @Override
    public List<AttributedGraph> parse() {
        ArrayList<AttributedGraph> res = new ArrayList<AttributedGraph>();
        Set graphs = this.run.getGraphs();
        if (graphs != null) {
            for (Graph g : graphs) {
                String description = g.getDescription() == null ? this.controller.getProgram().getDescription() : g.getDescription().getText();
                AttributedGraph graph = new AttributedGraph(description, (GraphType)new EmptyGraphType());
                HashMap<String, AttributedVertex> nodeMap = new HashMap<String, AttributedVertex>();
                for (Node n : g.getNodes()) {
                    nodeMap.put(n.getId(), graph.addVertex(n.getId(), n.getLabel().getText()));
                }
                for (Edge e : g.getEdges()) {
                    graph.addEdge((AttributedVertex)nodeMap.get(e.getSourceNodeId()), (AttributedVertex)nodeMap.get(e.getTargetNodeId()));
                }
                res.add(graph);
            }
        }
        return res;
    }

    @Override
    public void handle(SarifDataFrame df, Run run) {
        this.df = df;
        this.controller = df.getController();
        this.run = run;
        Object res = this.parse();
        if (res != null) {
            Iterator iterator = res.iterator();
            while (iterator.hasNext()) {
                AttributedGraph g = (AttributedGraph)iterator.next();
                this.controller.showGraph(g);
            }
        }
    }
}

