/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.result;

import com.contrastsecurity.sarif.Edge;
import com.contrastsecurity.sarif.Graph;
import com.contrastsecurity.sarif.Node;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sarif.handlers.SarifResultHandler;

public class SarifGraphResultHandler
extends SarifResultHandler {
    @Override
    public String getKey() {
        return "Graphs";
    }

    @Override
    public List<AttributedGraph> parse() {
        ArrayList<AttributedGraph> res = new ArrayList<AttributedGraph>();
        Set graphs = this.result.getGraphs();
        if (graphs != null) {
            for (Graph g : graphs) {
                res.add(this.parseGraph(g));
            }
        }
        return res;
    }

    private AttributedGraph parseGraph(Graph g) {
        AttributedGraph graph = new AttributedGraph(this.controller.getProgram().getDescription(), (GraphType)new EmptyGraphType());
        HashMap<String, AttributedVertex> nodeMap = new HashMap<String, AttributedVertex>();
        for (Node n : g.getNodes()) {
            nodeMap.put(n.getId(), graph.addVertex(n.getId(), n.getLabel().getText()));
        }
        for (Edge e : g.getEdges()) {
            graph.addEdge((AttributedVertex)nodeMap.get(e.getSourceNodeId()), (AttributedVertex)nodeMap.get(e.getTargetNodeId()));
        }
        return graph;
    }
}

