/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class SH_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 42 && elf.is32Bit();
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 42 || !elf.is32Bit()) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return RelocationResult.SKIPPED;
        }
        int symbolIndex = relocation.getSymbolIndex();
        int addend = (int)relocation.getAddend();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        int offset = (int)relocationAddress.getOffset();
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        int symbolValue = (int)elfRelocationContext.getSymbolValue(sym);
        int newValue = 0;
        int byteLength = 4;
        switch (type) {
            case 1: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                if (symbolIndex == 0 || addend == 0 || sym.isSection()) break;
                SH_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                SH_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 163: 
            case 164: {
                memory.setInt(relocationAddress, symbolValue);
                break;
            }
            case 2: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = symbolValue + addend - offset;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 3: 
            case 6: {
                short oldValue = memory.getShort(relocationAddress);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFF;
                    if (type == 3 && (addend & 0x80) != 0) {
                        addend -= 256;
                    }
                }
                newValue = symbolValue + addend - offset >> 1;
                newValue = oldValue & 0xFF00 | newValue & 0xFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 4: {
                short oldValue = memory.getShort(relocationAddress);
                if (elfRelocationContext.extractAddend() && ((addend = oldValue & 0xFFF) & 0x800) != 0) {
                    addend -= 4096;
                }
                newValue = symbolValue + addend - offset >> 1;
                newValue = oldValue & 0xF000 | newValue & 0xFFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 5: {
                short oldValue = memory.getShort(relocationAddress);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFF;
                }
                newValue = symbolValue + addend - offset >> 2;
                newValue = oldValue & 0xFF00 | newValue & 0xFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 162: {
                SH_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_SH_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 165: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            default: {
                SH_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

