/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class HiDPIUtils {
    public static void paintAtScale1x(Graphics g0, int x, int y, int width, int height, HiDPIPainter painter) {
        HiDPIUtils.paintAtScale1x(g0, x, y, width, height, false, false, painter);
    }

    static void paintAtScale1x(Graphics g0, int x, int y, int width, int height, boolean roundXdown, boolean roundYdown, HiDPIPainter painter) {
        Graphics2D g = (Graphics2D)g0;
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        AffineTransform tx = g.getTransform();
        int txType = tx.getType();
        if (txType == 2 || txType == 3) {
            double scale = tx.getScaleX();
            int deviceX = (int)(roundXdown ? Math.floor(tx.getTranslateX()) : (double)Math.round(tx.getTranslateX()));
            int deviceY = (int)(roundYdown ? Math.floor(tx.getTranslateY()) : (double)Math.round(tx.getTranslateY()));
            int deviceXend = (int)Math.floor(tx.getTranslateX() + (double)width * scale);
            int deviceYend = (int)Math.floor(tx.getTranslateY() + (double)height * scale);
            int deviceWidth = deviceXend - deviceX;
            int deviceHeight = deviceYend - deviceY;
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, deviceX, deviceY));
            painter.paint(g, deviceWidth, deviceHeight, scale);
        } else {
            painter.paint(g, width, height, 1.0);
        }
        g.setTransform(oldTransform);
    }

    public static int deviceBorderWidth(double scale, int logical) {
        if (logical <= 0) {
            return 0;
        }
        return Math.max(1, (int)(scale * (double)logical));
    }

    public static interface HiDPIPainter {
        public void paint(Graphics2D var1, int var2, int var3, double var4);
    }
}

