/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo;

import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec3f;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.ViewerPose;

public class StereoUtil {
    public static float getVertPupilCenterFromTop(float f, float f2) {
        return f2 / f;
    }

    public static float[] getHorizPupilCenterFromLeft(float f, float f2) {
        float f3 = 0.5f * f;
        float f4 = (f - f2) * 0.5f;
        float f5 = f4 + f2 - f3;
        return new float[]{f4 / f3, f5 / f3};
    }

    public static boolean usesBarrelDistortion(int n) {
        return 0 != (n & 1);
    }

    public static boolean usesTimewarpDistortion(int n) {
        return 0 != (n & 8);
    }

    public static boolean usesChromaticDistortion(int n) {
        return 0 != (n & 2);
    }

    public static boolean usesVignetteDistortion(int n) {
        return 0 != (n & 4);
    }

    public static String distortionBitsToString(int n) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (StereoUtil.usesBarrelDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("barrel");
            bl = true;
        }
        if (StereoUtil.usesVignetteDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("vignette");
            bl = true;
        }
        if (StereoUtil.usesChromaticDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("chroma");
            bl = true;
        }
        if (StereoUtil.usesTimewarpDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("timewarp");
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static boolean usesOrientationSensor(int n) {
        return 0 != (n & 1);
    }

    public static boolean usesYawCorrectionSensor(int n) {
        return 0 != (n & 2);
    }

    public static boolean usesPositionSensor(int n) {
        return 0 != (n & 4);
    }

    public static String sensorBitsToString(int n) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (StereoUtil.usesOrientationSensor(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("orientation");
            bl = true;
        }
        if (StereoUtil.usesYawCorrectionSensor(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("yaw-corr");
            bl = true;
        }
        if (StereoUtil.usesPositionSensor(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("position");
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static void getSBSUpstreamPMV(ViewerPose viewerPose, StereoDeviceRenderer.Eye eye, float f, float f2, Matrix4f matrix4f, Matrix4f matrix4f2) {
        Matrix4f matrix4f3 = new Matrix4f();
        Matrix4f matrix4f4 = new Matrix4f();
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        EyeParameter eyeParameter = eye.getEyeParameter();
        matrix4f.setToPerspective(eyeParameter.fovhv, f, f2);
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f4 = quaternion.rotateVector(viewerPose.position, vec3f).add(eyeParameter.positionOffset);
        quaternion.mult(viewerPose.orientation);
        Vec3f vec3f5 = quaternion.rotateVector(Vec3f.UNIT_Y, vec3f2);
        Vec3f vec3f6 = quaternion.rotateVector(Vec3f.UNIT_Z_NEG, vec3f3);
        Vec3f vec3f7 = vec3f6.add(vec3f4);
        Matrix4f matrix4f5 = matrix4f4.setToLookAt(vec3f4, vec3f7, vec3f5, matrix4f3);
        matrix4f2.mul(matrix4f3.setToTranslation(eyeParameter.distNoseToPupilX, eyeParameter.distMiddleToPupilY, eyeParameter.eyeReliefZ), matrix4f5);
    }
}

