/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import javax.swing.Box;
import javax.swing.JCheckBox;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.features.filepreview.MindMapPreview;

public class MindMapPreviewWithOptions
extends Box {
    private static final long serialVersionUID = 1L;
    private final JCheckBox follow;
    private final JCheckBox associate;
    private final JFileChooser fileChooser;

    public static MindMapPreviewWithOptions createFileOpenDialogAndOptions(String title) {
        ModeController modeController = Controller.getCurrentModeController();
        MFileManager fileManager = MFileManager.getController((ModeController)modeController);
        JFreeplaneCustomizableFileChooser fileChooser = fileManager.getMindMapFileChooser();
        MindMapPreviewWithOptions previewWithOptions = new MindMapPreviewWithOptions(fileChooser);
        previewWithOptions.hideOptions();
        fileChooser.setAccessory(previewWithOptions);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(title);
        return previewWithOptions;
    }

    public MindMapPreviewWithOptions(JFileChooser fileChooser) {
        this(new MindMapPreview(fileChooser), fileChooser);
    }

    private MindMapPreviewWithOptions(MindMapPreview preview, JFileChooser fileChooser) {
        super(1);
        this.fileChooser = fileChooser;
        preview.setAlignmentX(0.0f);
        this.add(preview);
        this.follow = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.follow, TextUtils.getRawText("followMindMap"));
        this.follow.setAlignmentX(0.0f);
        this.associate = new JCheckBox();
        this.associate.setSelected(true);
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.associate, TextUtils.getRawText("associateUpdatedTemplate"));
        this.associate.setAlignmentX(0.0f);
        Box checkboxes = Box.createHorizontalBox();
        checkboxes.setAlignmentX(0.0f);
        checkboxes.add(this.follow);
        checkboxes.add(Box.createHorizontalStrut((int)(10.0f * UITools.FONT_SCALE_FACTOR)));
        checkboxes.add(this.associate);
        this.add(checkboxes);
    }

    public MindMapPreviewWithOptions selectFollows() {
        this.follow.setSelected(true);
        return this;
    }

    public MindMapPreviewWithOptions associateAlways() {
        this.associate.setSelected(true);
        this.associate.setEnabled(false);
        return this;
    }

    public boolean isFollowChecked() {
        return this.follow.isSelected();
    }

    public boolean isAssociateChecked() {
        return this.associate.isSelected();
    }

    public MindMapPreviewWithOptions hideOptions() {
        this.follow.setVisible(false);
        this.associate.setVisible(false);
        return this;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }
}

