/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIAssistant;
import org.jkiss.dbeaver.model.ai.impl.AIAssistantImpl;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantDescriptor;
import org.jkiss.dbeaver.model.app.DBPWorkspace;

public class AIAssistantRegistry {
    private static AIAssistantRegistry instance = null;
    private final AIAssistantDescriptor customDescriptor;

    public static synchronized AIAssistantRegistry getInstance() {
        if (instance == null) {
            instance = new AIAssistantRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIAssistantRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        AIAssistantDescriptor customAssistantDescriptor = null;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.assistant");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("assistant".equals(ext.getName())) {
                customAssistantDescriptor = new AIAssistantDescriptor(ext);
                break;
            }
            ++n2;
        }
        this.customDescriptor = customAssistantDescriptor;
    }

    @NotNull
    public <T extends AIAssistant> T createAssistant(@NotNull DBPWorkspace workspace) throws IllegalStateException {
        AIAssistant assistant;
        if (this.customDescriptor != null) {
            try {
                assistant = this.customDescriptor.createInstance();
            }
            catch (DBException e) {
                throw new IllegalStateException(e);
            }
        } else {
            assistant = new AIAssistantImpl();
        }
        assistant.initialize(workspace);
        return (T)assistant;
    }
}

