/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.tasks.DB2RunstatsOptions;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;

public class DB2RunstatsToolSettings
extends SQLToolExecuteSettings<DB2TableBase> {
    private static final String[] columnStats = new String[]{DB2RunstatsOptions.colsAll.getDesc(), DB2RunstatsOptions.colsAllAndDistribution.getDesc(), DB2RunstatsOptions.colsNo.getDesc()};
    private static final String[] indexStats = new String[]{DB2RunstatsOptions.indexesDetailed.getDesc(), DB2RunstatsOptions.indexesAll.getDesc(), DB2RunstatsOptions.indexesNo.getDesc()};
    private String columnStat;
    private String indexStat;
    private boolean isTableSampling;
    private int samplePercent;

    @Property(viewable=true, editable=true, updatable=true, order=1, listProvider=CheckStorageOptionListProvider.class)
    public String getColumnStat() {
        if (this.columnStat == null) {
            this.columnStat = DB2RunstatsOptions.getOption(columnStats[0]).getDesc();
        }
        return this.columnStat;
    }

    public void setColumnStat(String columnStat) {
        this.columnStat = columnStat;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2, listProvider=CheckTriggersOptionListProvider.class)
    public String getIndexStat() {
        if (this.indexStat == null) {
            this.indexStat = DB2RunstatsOptions.getOption(indexStats[0]).getDesc();
        }
        return this.indexStat;
    }

    public void setIndexStat(String storageOption) {
        this.indexStat = storageOption;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    public boolean isTableSampling() {
        return this.isTableSampling;
    }

    public void setTableSampling(boolean tableSampling) {
        this.isTableSampling = tableSampling;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4, valueValidator=DB2StatisticPercentLimiter.class)
    public int getSamplePercent() {
        return this.samplePercent;
    }

    public void setSamplePercent(int samplePercent) {
        this.samplePercent = samplePercent;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.columnStat = JSONUtils.getString(config, (String)"column_stat");
        this.indexStat = JSONUtils.getString(config, (String)"index_stat");
        this.isTableSampling = JSONUtils.getBoolean(config, (String)"is_table_sampling");
        this.samplePercent = JSONUtils.getInteger(config, (String)"sample_percent");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("column_stat", this.columnStat);
        config.put("index_stat", this.indexStat);
        config.put("is_table_sampling", this.isTableSampling);
        config.put("sample_percent", this.samplePercent);
    }

    public static class CheckStorageOptionListProvider
    implements IPropertyValueListProvider<DB2RunstatsToolSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(DB2RunstatsToolSettings object) {
            return columnStats;
        }
    }

    public static class CheckTriggersOptionListProvider
    implements IPropertyValueListProvider<DB2RunstatsToolSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(DB2RunstatsToolSettings object) {
            return indexStats;
        }
    }

    public static class DB2StatisticPercentLimiter
    implements IPropertyValueValidator<DB2RunstatsToolSettings, Object> {
        public boolean isValidValue(DB2RunstatsToolSettings object, Object value) throws IllegalArgumentException {
            int i = -1;
            if (value instanceof String) {
                i = Integer.parseInt((String)value);
            }
            return i >= 0 && i <= 100;
        }
    }
}

