/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class CubridProcedure
extends GenericProcedure
implements DBSObjectWithScript,
DBPRefreshableObject {
    private List<CubridProcedureParameter> proColumns;
    private DBSProcedureType procedureType;
    private String returnType;
    private String source;

    public CubridProcedure(@NotNull GenericStructContainer container, @NotNull String procedureName, @Nullable String description, @NotNull DBSProcedureType procedureType, @Nullable String source, @NotNull String returnType) {
        super(container, procedureName, description, procedureType, source, true);
        this.procedureType = procedureType;
        this.returnType = returnType;
        this.source = source;
    }

    public CubridProcedure(@NotNull GenericStructContainer container, DBSProcedureType procedureType) {
        super(container, null, null, procedureType, null, false);
        this.procedureType = procedureType;
    }

    @Property(viewable=true, order=2, labelProvider=GenericSchema.SchemaNameTermProvider.class)
    @NotNull
    public GenericSchema getSchema() {
        return super.getSchema();
    }

    @Nullable
    public GenericCatalog getCatalog() {
        return null;
    }

    @Property(order=2)
    public DBSProcedureType getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(DBSProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    @Nullable
    public GenericFunctionResultType getFunctionResultType() {
        return null;
    }

    @Nullable
    public GenericPackage getPackage() {
        return null;
    }

    @Property(viewable=true, order=20)
    @NotNull
    public String getReturnType() {
        return this.returnType;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public void addColumn(@NotNull CubridProcedureParameter column) {
        if (this.proColumns == null) {
            this.proColumns = new ArrayList<CubridProcedureParameter>();
        }
        this.proColumns.add(column);
    }

    @Nullable
    public List<CubridProcedureParameter> getParams(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.proColumns == null) {
            this.loadProcedureColumns(monitor);
            if (this.proColumns == null) {
                this.proColumns = new ArrayList<CubridProcedureParameter>();
            }
        }
        return this.proColumns;
    }

    @Property(hidden=true, editable=true, updatable=true)
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            if (!this.persisted) {
                this.source = "CREATE OR REPLACE " + this.getProcedureType().name() + " " + this.getName() + "()";
                this.source = String.valueOf(this.source) + (this.getProcedureType() == DBSProcedureType.FUNCTION ? " RETURN int" : "");
                this.source = String.valueOf(this.source) + "\nAS LANGUAGE JAVA NAME";
            } else {
                this.source = "-- Java procedure definition not available";
            }
        }
        return this.source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setObjectDefinitionText(String source) {
        this.setSource(source);
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.getName();
    }

    public void loadProcedureColumns(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read procedure parameter");){
                String stmt = "select * from db_stored_procedure_args where sp_name = ?";
                stmt = ((CubridDataSource)this.getDataSource()).wrapShardQuery(stmt);
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
                    dbStat.setString(1, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String argName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"arg_name");
                            String dataType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"data_type");
                            String mode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"mode");
                            String comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
                            this.addColumn(new CubridProcedureParameter(this, argName, dataType, mode, comment));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, this.getDataSource());
        }
    }
}

