/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.stones;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public abstract class Runestone
extends Item {
    protected boolean pressesCell;

    public Runestone() {
        this.stackable = true;
        this.defaultAction = "THROW";
        this.pressesCell = true;
    }

    @Override
    protected void onThrow(int cell) {
        if (Dungeon.level.pit[cell] || !this.defaultAction().equals("THROW")) {
            super.onThrow(cell);
        } else {
            if (this.pressesCell) {
                Dungeon.level.pressCell(cell);
            }
            this.activate(cell);
            Invisibility.dispel();
        }
    }

    protected abstract void activate(int var1);

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return 15 * this.quantity;
    }

    @Override
    public int energyVal() {
        return 3 * this.quantity;
    }

    public static class PlaceHolder
    extends Runestone {
        public PlaceHolder() {
            this.image = ItemSpriteSheet.STONE_HOLDER;
        }

        @Override
        protected void activate(int cell) {
        }

        @Override
        public boolean isSimilar(Item item) {
            return item instanceof Runestone;
        }

        @Override
        public String info() {
            return "";
        }
    }
}

