/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class AllDifferentCreator {
    private final OWLOntology ont;
    private final Set<OWLOntology> ontologies;
    private final OWLDataFactory dataFactory;

    public AllDifferentCreator(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLOntology ont, @Nonnull Set<OWLOntology> ontologies) {
        this.ont = (OWLOntology)Preconditions.checkNotNull((Object)ont);
        this.ontologies = new HashSet<OWLOntology>((Collection)Preconditions.checkNotNull(ontologies));
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
    }

    public List<OWLOntologyChange> getChanges() {
        Set individuals = this.ontologies.stream().flatMap(o -> o.getIndividualsInSignature().stream()).collect(Collectors.toSet());
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        if (!individuals.isEmpty()) {
            changes.add((OWLOntologyChange)new AddAxiom(this.ont, (OWLAxiom)this.dataFactory.getOWLDifferentIndividualsAxiom(individuals)));
        }
        return changes;
    }
}

