/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregatorFunction;
import org.opensearch.sql.expression.datetime.DateTimeFunction;
import org.opensearch.sql.expression.datetime.IntervalClause;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionImplementation;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.function.OpenSearchFunctions;
import org.opensearch.sql.expression.operator.arthmetic.ArithmeticFunction;
import org.opensearch.sql.expression.operator.arthmetic.MathematicalFunction;
import org.opensearch.sql.expression.operator.convert.TypeCastOperator;
import org.opensearch.sql.expression.operator.predicate.BinaryPredicateOperator;
import org.opensearch.sql.expression.operator.predicate.UnaryPredicateOperator;
import org.opensearch.sql.expression.system.SystemFunctions;
import org.opensearch.sql.expression.text.TextFunction;
import org.opensearch.sql.expression.window.WindowFunctions;

public class BuiltinFunctionRepository {
    private final Map<FunctionName, FunctionResolver> functionResolverMap;
    private static BuiltinFunctionRepository instance;

    @VisibleForTesting
    BuiltinFunctionRepository(Map<FunctionName, FunctionResolver> functionResolverMap) {
        this.functionResolverMap = functionResolverMap;
    }

    public static synchronized BuiltinFunctionRepository getInstance() {
        if (instance == null) {
            instance = new BuiltinFunctionRepository(new HashMap<FunctionName, FunctionResolver>());
            ArithmeticFunction.register(instance);
            BinaryPredicateOperator.register(instance);
            MathematicalFunction.register(instance);
            UnaryPredicateOperator.register(instance);
            AggregatorFunction.register(instance);
            DateTimeFunction.register(instance);
            IntervalClause.register(instance);
            WindowFunctions.register(instance);
            TextFunction.register(instance);
            TypeCastOperator.register(instance);
            SystemFunctions.register(instance);
            OpenSearchFunctions.register(instance);
        }
        return instance;
    }

    public void register(FunctionResolver resolver) {
        this.functionResolverMap.put(resolver.getFunctionName(), resolver);
    }

    public FunctionImplementation compile(FunctionProperties functionProperties, FunctionName functionName, List<Expression> expressions) {
        return this.compile(functionProperties, Collections.emptyList(), functionName, expressions);
    }

    public FunctionImplementation compile(FunctionProperties functionProperties, Collection<FunctionResolver> dataSourceFunctionResolver, FunctionName functionName, List<Expression> expressions) {
        FunctionBuilder resolvedFunctionBuilder = this.resolve(dataSourceFunctionResolver, new FunctionSignature(functionName, expressions.stream().map(Expression::type).collect(Collectors.toList())));
        return resolvedFunctionBuilder.apply(functionProperties, expressions);
    }

    @VisibleForTesting
    public FunctionBuilder resolve(Collection<FunctionResolver> dataSourceFunctionResolver, FunctionSignature functionSignature) {
        Map<FunctionName, FunctionResolver> dataSourceFunctionMap = dataSourceFunctionResolver.stream().collect(Collectors.toMap(FunctionResolver::getFunctionName, t -> t));
        return this.resolve(functionSignature, dataSourceFunctionMap).or(() -> this.resolve(functionSignature, this.functionResolverMap)).orElseThrow(() -> new ExpressionEvaluationException(String.format("unsupported function name: %s", functionSignature.getFunctionName())));
    }

    private Optional<FunctionBuilder> resolve(FunctionSignature functionSignature, Map<FunctionName, FunctionResolver> functionResolverMap) {
        FunctionName functionName = functionSignature.getFunctionName();
        if (functionResolverMap.containsKey(functionName)) {
            Pair<FunctionSignature, FunctionBuilder> resolvedSignature = functionResolverMap.get(functionName).resolve(functionSignature);
            List<ExprType> sourceTypes = functionSignature.getParamTypeList();
            List<ExprType> targetTypes = ((FunctionSignature)resolvedSignature.getKey()).getParamTypeList();
            FunctionBuilder funcBuilder = (FunctionBuilder)resolvedSignature.getValue();
            if (Cast.isCastFunction(functionName) || FunctionSignature.isVarArgFunction(targetTypes) || sourceTypes.equals(targetTypes)) {
                return Optional.of(funcBuilder);
            }
            return Optional.of(this.castArguments(sourceTypes, targetTypes, funcBuilder));
        }
        return Optional.empty();
    }

    private FunctionBuilder castArguments(List<ExprType> sourceTypes, List<ExprType> targetTypes, FunctionBuilder funcBuilder) {
        return (fp, arguments) -> {
            ArrayList<Expression> argsCasted = new ArrayList<Expression>();
            for (int i = 0; i < arguments.size(); ++i) {
                ExprType targetType;
                Expression arg = (Expression)arguments.get(i);
                ExprType sourceType = (ExprType)sourceTypes.get(i);
                if (this.isCastRequired(sourceType, targetType = (ExprType)targetTypes.get(i))) {
                    argsCasted.add(this.cast(arg, targetType).apply(fp));
                    continue;
                }
                argsCasted.add(arg);
            }
            return funcBuilder.apply(fp, argsCasted);
        };
    }

    private boolean isCastRequired(ExprType sourceType, ExprType targetType) {
        if (ExprCoreType.numberTypes().contains(sourceType) && ExprCoreType.numberTypes().contains(targetType)) {
            return false;
        }
        return sourceType.shouldCast(targetType);
    }

    private Function<FunctionProperties, Expression> cast(Expression arg, ExprType targetType) {
        FunctionName castFunctionName = Cast.getCastFunctionName(targetType);
        if (castFunctionName == null) {
            throw new ExpressionEvaluationException(StringUtils.format((String)"Type conversion to type %s is not supported", (Object[])new Object[]{targetType}));
        }
        return functionProperties -> (Expression)((Object)this.compile((FunctionProperties)functionProperties, castFunctionName, List.of(arg)));
    }
}

