/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import lombok.Generated;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.analysis.QualifierAnalyzer;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.NamedExpression;

public class NamedExpressionAnalyzer
extends AbstractNodeVisitor<NamedExpression, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;

    public NamedExpression analyze(UnresolvedExpression expression, AnalysisContext analysisContext) {
        return expression.accept(this, analysisContext);
    }

    @Override
    public NamedExpression visitAlias(Alias node, AnalysisContext context) {
        return DSL.named(this.unqualifiedNameIfFieldOnly(node, context), node.getDelegated().accept(this.expressionAnalyzer, context), node.getAlias());
    }

    private String unqualifiedNameIfFieldOnly(Alias node, AnalysisContext context) {
        UnresolvedExpression selectItem = node.getDelegated();
        if (selectItem instanceof QualifiedName) {
            QualifierAnalyzer qualifierAnalyzer = new QualifierAnalyzer(context);
            return qualifierAnalyzer.unqualified((QualifiedName)selectItem);
        }
        return node.getName();
    }

    @Generated
    public NamedExpressionAnalyzer(ExpressionAnalyzer expressionAnalyzer) {
        this.expressionAnalyzer = expressionAnalyzer;
    }
}

