/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.client;

import com.amazonaws.services.emrserverless.AWSEMRServerless;
import com.amazonaws.services.emrserverless.model.CancelJobRunRequest;
import com.amazonaws.services.emrserverless.model.CancelJobRunResult;
import com.amazonaws.services.emrserverless.model.GetJobRunRequest;
import com.amazonaws.services.emrserverless.model.GetJobRunResult;
import com.amazonaws.services.emrserverless.model.JobDriver;
import com.amazonaws.services.emrserverless.model.SparkSubmit;
import com.amazonaws.services.emrserverless.model.StartJobRunRequest;
import com.amazonaws.services.emrserverless.model.StartJobRunResult;
import com.amazonaws.services.emrserverless.model.ValidationException;
import java.security.AccessController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.client.StartJobRequest;

public class EmrServerlessClientImpl
implements EMRServerlessClient {
    private final AWSEMRServerless emrServerless;
    private static final Logger logger = LogManager.getLogger(EmrServerlessClientImpl.class);

    public EmrServerlessClientImpl(AWSEMRServerless emrServerless) {
        this.emrServerless = emrServerless;
    }

    @Override
    public String startJobRun(StartJobRequest startJobRequest) {
        String resultIndex = startJobRequest.getResultIndex() == null ? ".query_execution_result" : startJobRequest.getResultIndex();
        StartJobRunRequest request = new StartJobRunRequest().withName(startJobRequest.getJobName()).withApplicationId(startJobRequest.getApplicationId()).withExecutionRoleArn(startJobRequest.getExecutionRoleArn()).withTags(startJobRequest.getTags()).withExecutionTimeoutMinutes(startJobRequest.executionTimeout()).withJobDriver(new JobDriver().withSparkSubmit(new SparkSubmit().withEntryPoint("file:///home/hadoop/.ivy2/jars/org.opensearch_opensearch-spark-sql-application_2.12-0.1.0-SNAPSHOT.jar").withEntryPointArguments(new String[]{startJobRequest.getQuery(), resultIndex}).withSparkSubmitParameters(startJobRequest.getSparkSubmitParams())));
        StartJobRunResult startJobRunResult = AccessController.doPrivileged(() -> this.emrServerless.startJobRun(request));
        logger.info("Job Run ID: " + startJobRunResult.getJobRunId());
        return startJobRunResult.getJobRunId();
    }

    @Override
    public GetJobRunResult getJobRunResult(String applicationId, String jobId) {
        GetJobRunRequest request = new GetJobRunRequest().withApplicationId(applicationId).withJobRunId(jobId);
        GetJobRunResult getJobRunResult = AccessController.doPrivileged(() -> this.emrServerless.getJobRun(request));
        logger.info("Job Run state: " + getJobRunResult.getJobRun().getState());
        return getJobRunResult;
    }

    @Override
    public CancelJobRunResult cancelJobRun(String applicationId, String jobId) {
        CancelJobRunRequest cancelJobRunRequest = new CancelJobRunRequest().withJobRunId(jobId).withApplicationId(applicationId);
        try {
            CancelJobRunResult cancelJobRunResult = AccessController.doPrivileged(() -> this.emrServerless.cancelJobRun(cancelJobRunRequest));
            logger.info(String.format("Job : %s cancelled", cancelJobRunResult.getJobRunId()));
            return cancelJobRunResult;
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(String.format("Couldn't cancel the queryId: %s due to %s", jobId, e.getMessage()));
        }
    }
}

