/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.env.Environment;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerPlugin;
import org.opensearch.performanceanalyzer.commons.collectors.ScheduledMetricCollectorsExecutor;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;

public class PerformanceAnalyzerController {
    private static final String PERFORMANCE_ANALYZER_ENABLED_CONF = "performance_analyzer_enabled.conf";
    private static final String RCA_ENABLED_CONF = "rca_enabled.conf";
    private static final String LOGGING_ENABLED_CONF = "logging_enabled.conf";
    private static final String BATCH_METRICS_ENABLED_CONF = "batch_metrics_enabled.conf";
    private static final String THREAD_CONTENTION_MONITORING_ENABLED_CONF = "thread_contention_monitoring_enabled.conf";
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerController.class);
    public static final int DEFAULT_NUM_OF_SHARDS_PER_COLLECTION = 0;
    private boolean paEnabled;
    private boolean rcaEnabled;
    private boolean loggingEnabled;
    private boolean batchMetricsEnabled;
    private boolean threadContentionMonitoringEnabled;
    private volatile int shardsPerCollection;
    private static final boolean paEnabledDefaultValue = false;
    private static final boolean rcaEnabledDefaultValue = true;
    private static final boolean loggingEnabledDefaultValue = false;
    private static final boolean batchMetricsEnabledDefaultValue = false;
    private static final boolean threadContentionMonitoringEnabledDefaultValue = false;
    private final ScheduledMetricCollectorsExecutor scheduledMetricCollectorsExecutor;

    public PerformanceAnalyzerController(ScheduledMetricCollectorsExecutor scheduledMetricCollectorsExecutor) {
        this.scheduledMetricCollectorsExecutor = scheduledMetricCollectorsExecutor;
        this.initPerformanceAnalyzerStateFromConf();
        this.initRcaStateFromConf();
        this.initLoggingStateFromConf();
        this.initBatchMetricsStateFromConf();
        this.initThreadContentionMonitoringStateFromConf();
        this.shardsPerCollection = 0;
    }

    public boolean isPerformanceAnalyzerEnabled() {
        return this.paEnabled;
    }

    public boolean isRcaEnabled() {
        return this.rcaEnabled;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public boolean isBatchMetricsEnabled() {
        return this.batchMetricsEnabled;
    }

    public boolean isThreadContentionMonitoringEnabled() {
        return this.threadContentionMonitoringEnabled;
    }

    public int getNodeStatsShardsPerCollection() {
        return this.shardsPerCollection;
    }

    public void updateNodeStatsShardsPerCollection(int value) {
        this.shardsPerCollection = value;
    }

    public void updatePerformanceAnalyzerState(boolean value) {
        this.paEnabled = value;
        if (this.scheduledMetricCollectorsExecutor != null) {
            this.scheduledMetricCollectorsExecutor.setEnabled(this.paEnabled);
        }
        this.saveStateToConf(this.paEnabled, PERFORMANCE_ANALYZER_ENABLED_CONF);
    }

    public void updateRcaState(boolean shouldEnable) {
        if (shouldEnable && !this.isPerformanceAnalyzerEnabled()) {
            return;
        }
        this.rcaEnabled = shouldEnable;
        this.saveStateToConf(this.rcaEnabled, RCA_ENABLED_CONF);
    }

    public void updateLoggingState(boolean shouldEnable) {
        if (shouldEnable && !this.isPerformanceAnalyzerEnabled()) {
            return;
        }
        this.loggingEnabled = shouldEnable;
        if (this.scheduledMetricCollectorsExecutor != null) {
            PerformanceAnalyzerMetrics.setIsMetricsLogEnabled((boolean)this.loggingEnabled);
        }
        this.saveStateToConf(this.loggingEnabled, LOGGING_ENABLED_CONF);
    }

    public void updateBatchMetricsState(boolean shouldEnable) {
        if (shouldEnable && !this.isPerformanceAnalyzerEnabled()) {
            return;
        }
        this.batchMetricsEnabled = shouldEnable;
        this.saveStateToConf(this.batchMetricsEnabled, BATCH_METRICS_ENABLED_CONF);
    }

    public void updateThreadContentionMonitoringState(boolean shouldEnable) {
        if (shouldEnable && !this.isPerformanceAnalyzerEnabled()) {
            return;
        }
        this.threadContentionMonitoringEnabled = shouldEnable;
        if (this.scheduledMetricCollectorsExecutor != null) {
            this.scheduledMetricCollectorsExecutor.setThreadContentionMonitoringEnabled(this.threadContentionMonitoringEnabled);
        }
        this.saveStateToConf(this.threadContentionMonitoringEnabled, THREAD_CONTENTION_MONITORING_ENABLED_CONF);
    }

    private void initPerformanceAnalyzerStateFromConf() {
        Path filePath = Paths.get(this.getDataDirectory(), PERFORMANCE_ANALYZER_ENABLED_CONF);
        PerformanceAnalyzerPlugin.invokePrivileged(() -> {
            boolean paEnabledFromConf;
            try {
                paEnabledFromConf = this.readBooleanFromFile(filePath);
            }
            catch (Exception e) {
                LOG.debug("Error reading Performance Analyzer state from Conf file", (Throwable)e);
                if (e instanceof NoSuchFileException) {
                    this.saveStateToConf(false, PERFORMANCE_ANALYZER_ENABLED_CONF);
                }
                paEnabledFromConf = false;
            }
            this.updatePerformanceAnalyzerState(paEnabledFromConf);
        });
    }

    private void initRcaStateFromConf() {
        Path filePath = Paths.get(this.getDataDirectory(), RCA_ENABLED_CONF);
        PerformanceAnalyzerPlugin.invokePrivileged(() -> {
            boolean rcaEnabledFromConf;
            try {
                rcaEnabledFromConf = this.readBooleanFromFile(filePath);
            }
            catch (Exception e) {
                LOG.debug("Error reading Performance Analyzer state from Conf file", (Throwable)e);
                if (e instanceof NoSuchFileException) {
                    this.saveStateToConf(true, RCA_ENABLED_CONF);
                }
                rcaEnabledFromConf = true;
            }
            this.updateRcaState(this.paEnabled && rcaEnabledFromConf);
        });
    }

    private void initLoggingStateFromConf() {
        Path filePath = Paths.get(this.getDataDirectory(), LOGGING_ENABLED_CONF);
        PerformanceAnalyzerPlugin.invokePrivileged(() -> {
            boolean loggingEnabledFromConf;
            try {
                loggingEnabledFromConf = this.readBooleanFromFile(filePath);
            }
            catch (Exception e) {
                LOG.debug("Error reading logging state from Conf file", (Throwable)e);
                if (e instanceof NoSuchFileException) {
                    this.saveStateToConf(false, LOGGING_ENABLED_CONF);
                }
                loggingEnabledFromConf = false;
            }
            this.updateLoggingState(this.paEnabled && loggingEnabledFromConf);
        });
    }

    private void initBatchMetricsStateFromConf() {
        Path filePath = Paths.get(this.getDataDirectory(), BATCH_METRICS_ENABLED_CONF);
        PerformanceAnalyzerPlugin.invokePrivileged(() -> {
            boolean batchMetricsEnabledFromConf;
            try {
                batchMetricsEnabledFromConf = this.readBooleanFromFile(filePath);
            }
            catch (NoSuchFileException e) {
                LOG.debug("Error reading Performance Analyzer state from Conf file", (Throwable)e);
                this.saveStateToConf(false, BATCH_METRICS_ENABLED_CONF);
                batchMetricsEnabledFromConf = false;
            }
            catch (Exception e) {
                LOG.debug("Error reading Performance Analyzer state from Conf file", (Throwable)e);
                batchMetricsEnabledFromConf = false;
            }
            this.updateBatchMetricsState(this.paEnabled && batchMetricsEnabledFromConf);
        });
    }

    private void initThreadContentionMonitoringStateFromConf() {
        Path filePath = Paths.get(this.getDataDirectory(), THREAD_CONTENTION_MONITORING_ENABLED_CONF);
        PerformanceAnalyzerPlugin.invokePrivileged(() -> {
            boolean threadContentionMonitoringEnabledFromConf;
            try {
                threadContentionMonitoringEnabledFromConf = this.readBooleanFromFile(filePath);
            }
            catch (NoSuchFileException e) {
                LOG.debug("Error reading Performance Analyzer state from Conf file", (Throwable)e);
                this.saveStateToConf(false, THREAD_CONTENTION_MONITORING_ENABLED_CONF);
                threadContentionMonitoringEnabledFromConf = false;
            }
            catch (Exception e) {
                LOG.debug("Error reading thread contention monitoring state from Conf file", (Throwable)e);
                threadContentionMonitoringEnabledFromConf = false;
            }
            this.updateThreadContentionMonitoringState(this.paEnabled && threadContentionMonitoringEnabledFromConf);
        });
    }

    private boolean readBooleanFromFile(Path filePath) throws Exception {
        try (Scanner sc = new Scanner(filePath);){
            String nextLine = sc.nextLine();
            boolean bl = Boolean.parseBoolean(nextLine);
            return bl;
        }
    }

    private String getDataDirectory() {
        return new Environment(OpenSearchResources.INSTANCE.getSettings(), OpenSearchResources.INSTANCE.getConfigPath()).dataFiles()[0].toFile().getPath();
    }

    private void saveStateToConf(boolean featureEnabled, String fileName) {
        PerformanceAnalyzerPlugin.invokePrivileged(() -> {
            try {
                Path destDir = Paths.get(this.getDataDirectory(), new String[0]);
                if (!Files.exists(destDir, new LinkOption[0])) {
                    StatsCollector.instance().logException(StatExceptionCode.CONFIG_DIR_NOT_FOUND);
                    Files.createDirectory(destDir, new FileAttribute[0]);
                }
                Files.write(Paths.get(this.getDataDirectory() + File.separator + fileName, new String[0]), String.valueOf(featureEnabled).getBytes(), new OpenOption[0]);
            }
            catch (Exception ex) {
                LOG.error(ex.toString(), (Throwable)ex);
            }
        });
    }

    public boolean isCollectorEnabled(ConfigOverridesWrapper configOverridesWrapper, String collectorName) {
        if (configOverridesWrapper == null) {
            return false;
        }
        List enabledCollectorsList = configOverridesWrapper.getCurrentClusterConfigOverrides().getEnable().getCollectors();
        return enabledCollectorsList.contains(collectorName);
    }

    public boolean isCollectorDisabled(ConfigOverridesWrapper configOverridesWrapper, String collectorName) {
        if (configOverridesWrapper == null) {
            return true;
        }
        List disabledCollectorsList = configOverridesWrapper.getCurrentClusterConfigOverrides().getDisable().getCollectors();
        return disabledCollectorsList.contains(collectorName);
    }
}

