/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.DecisionPolicy;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.LevelOneActionBuilder;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.LevelThreeActionBuilder;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.LevelTwoActionBuilder;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class OldGenDecisionPolicy
implements DecisionPolicy {
    private static final Logger LOG = LogManager.getLogger(OldGenDecisionPolicy.class);
    private AppContext appContext;
    private RcaConf rcaConf;
    private final HighHeapUsageClusterRca highHeapUsageClusterRca;

    public OldGenDecisionPolicy(HighHeapUsageClusterRca highHeapUsageClusterRca) {
        this.highHeapUsageClusterRca = highHeapUsageClusterRca;
    }

    public void setRcaConf(RcaConf rcaConf) {
        this.rcaConf = rcaConf;
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public List<Action> evaluate() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.highHeapUsageClusterRca.getFlowUnits().isEmpty()) {
            return actions;
        }
        ResourceFlowUnit flowUnit = (ResourceFlowUnit)this.highHeapUsageClusterRca.getFlowUnits().get(0);
        if (!flowUnit.hasResourceSummary()) {
            return actions;
        }
        HotClusterSummary clusterSummary = (HotClusterSummary)flowUnit.getSummary();
        for (HotNodeSummary nodeSummary : clusterSummary.getHotNodeSummaryList()) {
            NodeKey nodeKey = new NodeKey(nodeSummary.getNodeID(), nodeSummary.getHostAddress());
            for (HotResourceSummary resource : nodeSummary.getHotResourceSummaryList()) {
                if (!resource.getResource().equals(ResourceUtil.OLD_GEN_HEAP_USAGE)) continue;
                actions.addAll(this.evaluate(nodeKey, resource.getValue()));
            }
        }
        return actions;
    }

    private List<Action> evaluate(NodeKey nodeKey, double oldGenUsage) {
        if (this.rcaConf == null || this.appContext == null) {
            LOG.error("rca conf/app context is null, return empty action list");
            return new ArrayList<Action>();
        }
        OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig = this.rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        if (oldGenUsage >= oldGenDecisionPolicyConfig.oldGenThresholdLevelThree()) {
            return LevelThreeActionBuilder.newBuilder(nodeKey, this.appContext, this.rcaConf).build();
        }
        if (oldGenUsage >= oldGenDecisionPolicyConfig.oldGenThresholdLevelTwo()) {
            return LevelTwoActionBuilder.newBuilder(nodeKey, this.appContext, this.rcaConf).build();
        }
        if (oldGenUsage >= oldGenDecisionPolicyConfig.oldGenThresholdLevelOne()) {
            return LevelOneActionBuilder.newBuilder(nodeKey, this.appContext, this.rcaConf).build();
        }
        return new ArrayList<Action>();
    }
}

