/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.ml.common.dataframe.ColumnMeta;
import org.opensearch.ml.common.dataframe.ColumnType;
import org.opensearch.ml.common.dataframe.ColumnValue;
import org.opensearch.ml.common.dataframe.ColumnValueBuilder;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataframe.DataFrameType;
import org.opensearch.ml.common.dataframe.DefaultDataFrame;
import org.opensearch.ml.common.dataframe.Row;

public final class DataFrameBuilder {
    public static DataFrame emptyDataFrame(ColumnMeta[] columnMetas) {
        if (columnMetas == null || columnMetas.length == 0) {
            throw new IllegalArgumentException("columnMetas array is null or empty");
        }
        return new DefaultDataFrame(columnMetas);
    }

    public static DataFrame load(List<Map<String, Object>> input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("input is null or empty");
        }
        Map<String, Object> element = input.get(0);
        ColumnMeta[] columnMetas = new ColumnMeta[element.size()];
        int index = 0;
        for (Map.Entry<String, Object> entry : element.entrySet()) {
            ColumnMeta columnMeta = ColumnMeta.builder().name(entry.getKey()).columnType(ColumnType.from(entry.getValue())).build();
            columnMetas[index++] = columnMeta;
        }
        return DataFrameBuilder.load(columnMetas, input);
    }

    public static DataFrame load(ColumnMeta[] columnMetas, List<Map<String, Object>> input) {
        if (columnMetas == null || columnMetas.length == 0) {
            throw new IllegalArgumentException("columnMetas array is null or empty");
        }
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("input data list is null or empty");
        }
        int columnSize = columnMetas.length;
        HashMap<String, Integer> columnsMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnSize; ++i) {
            columnsMap.put(columnMetas[i].getName(), i);
        }
        List<Row> rows = input.stream().map(item -> {
            Row row = new Row(columnSize);
            if (item.size() != columnSize) {
                throw new IllegalArgumentException("input item map size is different in the map");
            }
            for (Map.Entry entry : item.entrySet()) {
                ColumnValue value;
                if (!columnsMap.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException("field of input item doesn't exist in columns, filed:" + (String)entry.getKey());
                }
                String columnName = (String)entry.getKey();
                int index = (Integer)columnsMap.get(columnName);
                ColumnType columnType = columnMetas[index].getColumnType();
                if (columnType != (value = ColumnValueBuilder.build(entry.getValue())).columnType()) {
                    throw new IllegalArgumentException("the same field has different data type");
                }
                row.setValue(index, value);
            }
            return row;
        }).collect(Collectors.toList());
        return new DefaultDataFrame(columnMetas, rows);
    }

    public static DataFrame load(StreamInput input) throws IOException {
        DataFrameType dataFrameType = (DataFrameType)input.readEnum(DataFrameType.class);
        switch (dataFrameType) {
            case DEFAULT: {
                return new DefaultDataFrame(input);
            }
        }
        throw new IllegalStateException("Unexpected value: " + dataFrameType);
    }

    @Generated
    private DataFrameBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

