/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.QueryPhaseResultConsumer;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseName;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.neuralsearch.processor.NormalizationProcessorWorkflow;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationTechnique;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.query.QuerySearchResult;

public class NormalizationProcessor
implements SearchPhaseResultsProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(NormalizationProcessor.class);
    public static final String TYPE = "normalization-processor";
    private final String tag;
    private final String description;
    private final ScoreNormalizationTechnique normalizationTechnique;
    private final ScoreCombinationTechnique combinationTechnique;
    private final NormalizationProcessorWorkflow normalizationWorkflow;

    public <Result extends SearchPhaseResult> void process(SearchPhaseResults<Result> searchPhaseResult, SearchPhaseContext searchPhaseContext) {
        if (this.shouldSkipProcessor(searchPhaseResult)) {
            log.debug("Query results are not compatible with normalization processor");
            return;
        }
        List<QuerySearchResult> querySearchResults = this.getQueryPhaseSearchResults(searchPhaseResult);
        Optional<FetchSearchResult> fetchSearchResult = this.getFetchSearchResults(searchPhaseResult);
        this.normalizationWorkflow.execute(querySearchResults, fetchSearchResult, this.normalizationTechnique, this.combinationTechnique);
    }

    public SearchPhaseName getBeforePhase() {
        return SearchPhaseName.QUERY;
    }

    public SearchPhaseName getAfterPhase() {
        return SearchPhaseName.FETCH;
    }

    public String getType() {
        return TYPE;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIgnoreFailure() {
        return false;
    }

    private <Result extends SearchPhaseResult> boolean shouldSkipProcessor(SearchPhaseResults<Result> searchPhaseResult) {
        if (Objects.isNull(searchPhaseResult) || !(searchPhaseResult instanceof QueryPhaseResultConsumer)) {
            return true;
        }
        QueryPhaseResultConsumer queryPhaseResultConsumer = (QueryPhaseResultConsumer)searchPhaseResult;
        return queryPhaseResultConsumer.getAtomicArray().asList().stream().filter(Objects::nonNull).noneMatch(this::isHybridQuery);
    }

    private boolean isHybridQuery(SearchPhaseResult searchPhaseResult) {
        return Objects.nonNull(searchPhaseResult.queryResult()) && Objects.nonNull(searchPhaseResult.queryResult().topDocs()) && Objects.nonNull(searchPhaseResult.queryResult().topDocs().topDocs.scoreDocs) && searchPhaseResult.queryResult().topDocs().topDocs.scoreDocs.length > 0 && HybridSearchResultFormatUtil.isHybridQueryStartStopElement(searchPhaseResult.queryResult().topDocs().topDocs.scoreDocs[0]);
    }

    private <Result extends SearchPhaseResult> List<QuerySearchResult> getQueryPhaseSearchResults(SearchPhaseResults<Result> results) {
        return results.getAtomicArray().asList().stream().map(result -> result == null ? null : result.queryResult()).collect(Collectors.toList());
    }

    private <Result extends SearchPhaseResult> Optional<FetchSearchResult> getFetchSearchResults(SearchPhaseResults<Result> searchPhaseResults) {
        Optional optionalFirstSearchPhaseResult = searchPhaseResults.getAtomicArray().asList().stream().findFirst();
        return optionalFirstSearchPhaseResult.map(SearchPhaseResult::fetchResult);
    }

    @Generated
    public NormalizationProcessor(String tag, String description, ScoreNormalizationTechnique normalizationTechnique, ScoreCombinationTechnique combinationTechnique, NormalizationProcessorWorkflow normalizationWorkflow) {
        this.tag = tag;
        this.description = description;
        this.normalizationTechnique = normalizationTechnique;
        this.combinationTechnique = combinationTechnique;
        this.normalizationWorkflow = normalizationWorkflow;
    }
}

