"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_BASE_API = exports.MONITOR_BASE_API = exports.EMAIL_GROUP_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = exports.DESTINATION_BASE_API = exports.DEFAULT_HEADERS = exports.CLUSTER = exports.API_ROUTE_PREFIX = exports.AD_BASE_API = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const API_ROUTE_PREFIX = '/_plugins/_alerting';
exports.API_ROUTE_PREFIX = API_ROUTE_PREFIX;
const MONITOR_BASE_API = `${API_ROUTE_PREFIX}/monitors`;
exports.MONITOR_BASE_API = MONITOR_BASE_API;
const WORKFLOW_BASE_API = `${API_ROUTE_PREFIX}/workflows`;
exports.WORKFLOW_BASE_API = WORKFLOW_BASE_API;
const AD_BASE_API = `/_plugins/_anomaly_detection/detectors`;
exports.AD_BASE_API = AD_BASE_API;
const DESTINATION_BASE_API = `${API_ROUTE_PREFIX}/destinations`;
exports.DESTINATION_BASE_API = DESTINATION_BASE_API;
const EMAIL_ACCOUNT_BASE_API = `${DESTINATION_BASE_API}/email_accounts`;
exports.EMAIL_ACCOUNT_BASE_API = EMAIL_ACCOUNT_BASE_API;
const EMAIL_GROUP_BASE_API = `${DESTINATION_BASE_API}/email_groups`;
exports.EMAIL_GROUP_BASE_API = EMAIL_GROUP_BASE_API;
const DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch-Dashboards'
};
exports.DEFAULT_HEADERS = DEFAULT_HEADERS;
const CLUSTER = {
  ADMIN: 'admin',
  ALERTING: 'opensearch_alerting',
  AD_ALERTING: 'alerting_ad',
  DATA: 'data'
};
exports.CLUSTER = CLUSTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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