/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.util.Objects;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

public class DeprecationRestHandler
implements RestHandler {
    private final RestHandler handler;
    private final String deprecationMessage;
    private final DeprecationLogger deprecationLogger;

    public DeprecationRestHandler(RestHandler handler, String deprecationMessage, DeprecationLogger deprecationLogger) {
        this.handler = Objects.requireNonNull(handler);
        this.deprecationMessage = DeprecationRestHandler.requireValidHeader(deprecationMessage);
        this.deprecationLogger = Objects.requireNonNull(deprecationLogger);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.deprecationLogger.deprecate("deprecated_route", this.deprecationMessage, new Object[0]);
        this.handler.handleRequest(request, channel, client);
    }

    @Override
    public boolean supportsContentStream() {
        return this.handler.supportsContentStream();
    }

    public static boolean validHeaderValue(String value) {
        if (!Strings.hasText((String)value)) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String requireValidHeader(String value) {
        if (!DeprecationRestHandler.validHeaderValue(value)) {
            throw new IllegalArgumentException("header value must contain only US ASCII text");
        }
        return value;
    }
}

