/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.RotatedTileBox;
import net.osmand.util.MapAlgorithms;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import org.apache.commons.logging.Log;

public abstract class OsmandMapLayer {
    private static final Log log = PlatformUtil.getLog(OsmandMapLayer.class);
    protected List<LatLon> fullObjectsLatLon;
    protected List<LatLon> smallObjectsLatLon;

    public abstract void initLayer(OsmBitmapPanel var1);

    public abstract void onDraw(Graphics2D var1, RotatedTileBox var2, DrawSettings var3);

    public void onPrepareBufferImage(Graphics2D canvas, RotatedTileBox tileBox, DrawSettings settings) {
    }

    public abstract void destroyLayer();

    public void onRetainNonConfigurationInstance(Map<String, Object> map) {
    }

    public void populateObjectContextMenu(LatLon latLon, Object o, JMenu adapter) {
    }

    public boolean onSingleTap(Point2D point, RotatedTileBox tileBox) {
        return false;
    }

    public boolean onLongPressEvent(Point2D point, RotatedTileBox tileBox) {
        return false;
    }

    public <Params> void executeTaskInBackground(Thread t) {
        t.run();
    }

    public boolean isPresentInFullObjects(LatLon latLon) {
        if (this.fullObjectsLatLon == null) {
            return true;
        }
        if (latLon != null) {
            return this.fullObjectsLatLon.contains(latLon);
        }
        return false;
    }

    public boolean isPresentInSmallObjects(LatLon latLon) {
        if (this.smallObjectsLatLon != null && latLon != null) {
            return this.smallObjectsLatLon.contains(latLon);
        }
        return false;
    }

    public abstract boolean drawInScreenPixels();

    private boolean isIn(int x, int y, int lx, int ty, int rx, int by) {
        return x >= lx && x <= rx && y >= ty && y <= by;
    }

    public int calculateSplitPaths(RotatedTileBox tb, TIntArrayList xs, TIntArrayList ys, TIntArrayList results) {
        int px = xs.get(0);
        int py = ys.get(0);
        int h = tb.getPixHeight();
        int w = tb.getPixWidth();
        int cnt = 0;
        boolean pin = this.isIn(px, py, 0, 0, w, h);
        Path2D.Double path = null;
        for (int i = 1; i < xs.size(); ++i) {
            int x = xs.get(i);
            int y = ys.get(i);
            boolean in = this.isIn(x, y, 0, 0, w, h);
            boolean draw = false;
            if (pin && in) {
                draw = true;
            } else {
                long intersection = MapAlgorithms.calculateIntersection(x, y, px, py, 0, w, h, 0);
                if (intersection != -1L) {
                    draw = true;
                }
            }
            if (draw) {
                path = new Path2D.Double();
                results.add(px);
                results.add(py);
                results.add(x);
                results.add(y);
            }
            pin = in;
            px = x;
            py = y;
        }
        return cnt;
    }

    public int calculatePath(RotatedTileBox tb, TIntArrayList xs, TIntArrayList ys, Path2D pPath) {
        boolean start = false;
        int px = xs.get(0);
        int py = ys.get(0);
        int h = tb.getPixHeight();
        int w = tb.getPixWidth();
        int cnt = 0;
        boolean pin = this.isIn(px, py, 0, 0, w, h);
        for (int i = 1; i < xs.size(); ++i) {
            int x = xs.get(i);
            int y = ys.get(i);
            boolean in = this.isIn(x, y, 0, 0, w, h);
            boolean draw = false;
            if (pin && in) {
                draw = true;
            } else {
                long intersection = MapAlgorithms.calculateIntersection(x, y, px, py, 0, w, h, 0);
                if (intersection != -1L) {
                    px = (int)(intersection >> 32);
                    py = (int)(intersection & 0xFFFFFFFFFFFFFFFFL);
                    draw = true;
                }
            }
            if (draw) {
                if (!start) {
                    ++cnt;
                    pPath.moveTo(px, py);
                }
                pPath.lineTo(x, y);
                start = true;
            } else {
                start = false;
            }
            pin = in;
            px = x;
            py = y;
        }
        return cnt;
    }

    public QuadTree<QuadRect> initBoundIntersections(RotatedTileBox tileBox) {
        QuadRect bounds = new QuadRect(0.0, 0.0, tileBox.getPixWidth(), tileBox.getPixHeight());
        bounds.inset(-bounds.width() / 4.0, -bounds.height() / 4.0);
        return new QuadTree<QuadRect>(bounds, 4, 0.6f);
    }

    public boolean intersects(QuadTree<QuadRect> boundIntersections, float x, float y, float width, float height) {
        ArrayList result = new ArrayList();
        QuadRect visibleRect = this.calculateRect(x, y, width, height);
        boundIntersections.queryInBox(new QuadRect(visibleRect.left, visibleRect.top, visibleRect.right, visibleRect.bottom), result);
        for (QuadRect r : result) {
            if (!QuadRect.intersects(r, visibleRect)) continue;
            return true;
        }
        boundIntersections.insert(visibleRect, new QuadRect(visibleRect.left, visibleRect.top, visibleRect.right, visibleRect.bottom));
        return false;
    }

    public QuadRect calculateRect(float x, float y, float width, float height) {
        double left = (double)x - (double)width / 2.0;
        double top = (double)y - (double)height / 2.0;
        double right = left + (double)width;
        double bottom = top + (double)height;
        QuadRect rf = new QuadRect(left, top, right, bottom);
        return rf;
    }

    public BufferedImage readImage(String image, OsmBitmapPanel view) {
        return view.getContext().readImage(image);
    }

    public abstract class MapLayerData<T> {
        public int ZOOM_THRESHOLD = 1;
        public RotatedTileBox queriedBox;
        protected T results;
        protected Task currentTask;
        protected Task pendingTask;

        public RotatedTileBox getQueriedBox() {
            return this.queriedBox;
        }

        public T getResults() {
            return this.results;
        }

        public boolean queriedBoxContains(RotatedTileBox queriedData, RotatedTileBox newBox) {
            return queriedData != null && queriedData.containsTileBox(newBox) && Math.abs(queriedData.getZoom() - newBox.getZoom()) <= this.ZOOM_THRESHOLD;
        }

        public void queryNewData(RotatedTileBox tileBox) {
            Task ct;
            if (!(this.queriedBoxContains(this.queriedBox, tileBox) || (ct = this.currentTask) != null && this.queriedBoxContains(ct.getDataBox(), tileBox))) {
                RotatedTileBox original = tileBox.copy();
                RotatedTileBox extended = original.copy();
                extended.increasePixelDimensions(tileBox.getPixWidth() / 2, tileBox.getPixHeight() / 2);
                Task task = new Task(original, extended);
                if (this.currentTask == null) {
                    OsmandMapLayer.this.executeTaskInBackground(task);
                } else {
                    this.pendingTask = task;
                }
            }
        }

        public void layerOnPostExecute() {
        }

        public boolean isInterrupted() {
            return this.pendingTask != null;
        }

        protected abstract T calculateResult(RotatedTileBox var1);

        public void clearCache() {
            this.results = null;
            this.queriedBox = null;
        }

        public class Task
        extends Thread {
            private RotatedTileBox dataBox;
            private RotatedTileBox requestedBox;

            public Task(RotatedTileBox requestedBox, RotatedTileBox dataBox) {
                this.requestedBox = requestedBox;
                this.dataBox = dataBox;
            }

            public RotatedTileBox getOriginalBox() {
                return this.requestedBox;
            }

            public RotatedTileBox getDataBox() {
                return this.dataBox;
            }

            @Override
            public void run() {
                if (MapLayerData.this.queriedBoxContains(MapLayerData.this.queriedBox, this.dataBox)) {
                    return;
                }
                MapLayerData.this.results = MapLayerData.this.calculateResult(this.dataBox);
            }

            protected void onPreExecute() {
                MapLayerData.this.currentTask = this;
            }

            protected void onPostExecute(T result) {
                if (result != null) {
                    MapLayerData.this.queriedBox = this.dataBox;
                    MapLayerData.this.results = result;
                }
                MapLayerData.this.currentTask = null;
                if (MapLayerData.this.pendingTask != null) {
                    OsmandMapLayer.this.executeTaskInBackground(MapLayerData.this.pendingTask);
                    MapLayerData.this.pendingTask = null;
                } else {
                    MapLayerData.this.layerOnPostExecute();
                }
            }
        }
    }

    public static class DrawSettings {
        private final boolean nightMode;
        private final boolean updateVectorRendering;

        public DrawSettings(boolean nightMode) {
            this(nightMode, false);
        }

        public DrawSettings(boolean nightMode, boolean updateVectorRendering) {
            this.nightMode = nightMode;
            this.updateVectorRendering = updateVectorRendering;
        }

        public boolean isUpdateVectorRendering() {
            return this.updateVectorRendering;
        }

        public boolean isNightMode() {
            return this.nightMode;
        }
    }
}

