# SPDX-FileCopyrightText: 2022 The Qt Company Ltd.
#
# SPDX-License-Identifier: BSD-3-Clause

function(set01 result)
    if (${ARGN})
        set("${result}" 1 PARENT_SCOPE)
    else()
        set("${result}" 0 PARENT_SCOPE)
    endif()
endfunction()

set01(LINUX CMAKE_SYSTEM_NAME STREQUAL "Linux")
set01(HPUX CMAKE_SYSTEM_NAME STREQUAL "HPUX")
set01(ANDROID CMAKE_SYSTEM_NAME STREQUAL "Android")
set01(NACL CMAKE_SYSTEM_NAME STREQUAL "NaCl")
set01(INTEGRITY CMAKE_SYSTEM_NAME STREQUAL "Integrity")
set01(VXWORKS CMAKE_SYSTEM_NAME STREQUAL "VxWorks")
set01(QNX CMAKE_SYSTEM_NAME STREQUAL "QNX")
set01(DARWIN CMAKE_SYSTEM_NAME STREQUAL "Darwin")
set01(OPENBSD CMAKE_SYSTEM_NAME STREQUAL "OpenBSD")
set01(FREEBSD CMAKE_SYSTEM_NAME STREQUAL "FreeBSD")
set01(NETBSD CMAKE_SYSTEM_NAME STREQUAL "NetBSD")
set01(WASM CMAKE_SYSTEM_NAME STREQUAL "Webassembly")

set01(BSD APPLE OR DARWIN OR OPENBSD OR FREEBSD OR NETBSD)

set01(WINRT WIN32 AND CMAKE_VS_PLATFORM_TOOSLET STREQUAL "winrt")

set01(APPLE_OSX APPLE)
set01(APPLE_UIKIT APPLE AND CMAKE_XCODE_PLATFORM_TOOLSET STREQUAL "uikit")
set01(APPLE_IOS APPLE AND CMAKE_XCODE_PLATFORM_TOOLSET STREQUAL "ios")
set01(APPLE_TVOS APPLE AND CMAKE_XCODE_PLATFORM_TOOLSET STREQUAL "tvos")
set01(APPLE_WATCHOS APPLE AND CMAKE_XCODE_PLATFORM_TOOLSET STREQUAL "watchos")

set01(ANDROID_EMBEDDED ANDROID)

set01(GCC CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
set01(CLANG CMAKE_CXX_COMPILER_ID MATCHES "Clang")
set01(ICC CMAKE_C_COMPILER MATCHES "icc|icl")

if(CMAKE_SIZEOF_VOID_P EQUAL 8)
    set(LIRI_64BIT TRUE)
elseif(CMAKE_SIZEOF_VOID_P EQUAL 4)
    set(LIRI_32BIT TRUE)
endif()
