/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.explorer.Command;
import org.freeplane.features.explorer.ExploringStep;

class ExploringStepBuilder {
    private final AccessedNodes accessedNodes;
    private static final String DOUBLE_QUOTED_STRING = "\"(?:[^\\\\\"]|\\\\.)*\"";
    private static final String SINGLE_QUOTED_STRING = "'(?:[^\\\\']|\\\\.)*'";
    private static final String ALIAS = "~(?>\\w|[-:+* ])+";
    private static final String SPACE = "\\s+";
    private static final String SEPARATOR = "/";
    private static final String GLOBAL = ":";
    private static final String ANCESTOR = "..";
    private static final String DESCENDANT = "**";
    private static final Pattern regex = Pattern.compile("\\s+|~(?>\\w|[-:+* ])+|'(?:[^\\\\']|\\\\.)*'|\"(?:[^\\\\\"]|\\\\.)*\"|/|^:|" + Pattern.quote("*") + "{1,2}|" + Pattern.quote(".."));
    private Matcher matcher;

    ExploringStepBuilder(String path, AccessedNodes accessedNodes) {
        this.matcher = regex.matcher(path.trim());
        this.accessedNodes = accessedNodes;
    }

    List<Command> buildSteps() {
        ArrayList<Command> commands = new ArrayList<Command>();
        int pathLength = this.matcher.regionEnd();
        boolean separatorFound = true;
        ExploringStep nextStep = ExploringStep.CHILD;
        while (this.matcher.lookingAt()) {
            String group = this.matcher.group();
            if (!Character.isWhitespace(group.charAt(0))) {
                if (group.contentEquals(SEPARATOR)) {
                    if (this.matcher.start() == 0) {
                        commands.add(this.command(ExploringStep.ROOT, ""));
                    } else {
                        if (separatorFound) {
                            throw new IllegalArgumentException("Unexpected / at pos " + this.matcher.start());
                        }
                        if (nextStep == ExploringStep.ANCESTOR) {
                            commands.add(this.command(ExploringStep.PARENT, ""));
                            nextStep = ExploringStep.CHILD;
                        }
                    }
                    separatorFound = true;
                } else if (group.contentEquals(GLOBAL)) {
                    nextStep = ExploringStep.GLOBAL;
                } else {
                    if (!separatorFound && nextStep != ExploringStep.ANCESTOR) {
                        throw new IllegalArgumentException("Expected / not found at pos " + this.matcher.start());
                    }
                    if (group.contentEquals(DESCENDANT)) {
                        nextStep = ExploringStep.DESCENDANT;
                    } else if (group.contentEquals(ANCESTOR)) {
                        if (nextStep == ExploringStep.ANCESTOR) {
                            throw new IllegalArgumentException("Unexpected .. at pos " + this.matcher.start());
                        }
                        nextStep = ExploringStep.ANCESTOR;
                    } else {
                        if (group.contentEquals("*")) {
                            commands.add(this.command(nextStep, "'...'"));
                        } else {
                            commands.add(this.command(nextStep, group));
                        }
                        nextStep = ExploringStep.CHILD;
                    }
                    separatorFound = false;
                }
            }
            this.matcher.region(this.matcher.end(), pathLength);
        }
        if (this.matcher.regionStart() != pathLength) {
            throw new IllegalArgumentException("Illegal element at pos " + this.matcher.regionStart());
        }
        if (nextStep == ExploringStep.DESCENDANT) {
            commands.add(this.command(ExploringStep.DESCENDANT, "'...'"));
        } else if (nextStep == ExploringStep.ANCESTOR) {
            commands.add(this.command(ExploringStep.PARENT, ""));
        }
        return commands;
    }

    private Command command(ExploringStep exploringStep, String searchedString) {
        return new Command(exploringStep, searchedString, this.accessedNodes);
    }
}

