import { Parser } from "../index.js";
import { bindSourceFile } from "../binder.js";
import { hover } from "./hover.js";
import { validateDocument } from "./validation.js";
import { findReferences, findDefinition } from "./reference.js";
import { renameSymbol } from "./rename.js";
import { getCompletions } from "./completion.js";
import { checkSourceFile } from "../checker.js";
import { getCodeActions, executeCommand, getAvailableCommands } from "./codeAction.js";
import { getDocumentColors, getColorRepresentations } from "./colorProvider.js";
function parseDocument(doc) {
    const parser = new Parser();
    const content = typeof doc === "string" ? doc : doc.getText();
    const sourceFile = parser.parse(content);
    bindSourceFile(sourceFile);
    checkSourceFile(sourceFile);
    return sourceFile;
}
export function createService() {
    return {
        parseDocument,
        validateDocument,
        hover,
        findReferences,
        findDefinition,
        renameSymbol,
        getCompletions,
        getDocumentColors,
        getColorRepresentations,
        getCodeActions,
        executeCommand,
        getAvailableCommands,
    };
}
//# sourceMappingURL=service.js.map