import { createChangeToEdit } from "./common.js";
import { findOptionalSemicolons } from "../../checker.js";
export function create() {
    return {
        title: "Remove optional semicolons",
        command: "DOT.removeSemicolons",
        arguments: undefined,
    };
}
export function execute(doc, sourceFile, cmd) {
    if (!isRemoveSemicolonsCommand(cmd))
        return undefined;
    const g = sourceFile.graph;
    if (!g)
        return undefined;
    const semicolons = findOptionalSemicolons(g);
    const edits = semicolons.map(s => {
        const end = s.end;
        const start = end - 1;
        return createChangeToEdit(doc.positionAt(start), doc.positionAt(end), "");
    });
    return {
        label: `Remove optional semicolons`,
        edit: {
            changes: {
                [doc.uri]: edits,
            }
        }
    };
}
function isRemoveSemicolonsCommand(cmd) {
    return cmd.command === "DOT.removeSemicolons"
        && (!cmd.arguments
            || cmd.arguments.length === 0
            || cmd.arguments.every(e => e === undefined));
}
//# sourceMappingURL=RemoveSemicolons.js.map