import QtQuick 2.1
import QtQuick.Controls 1.4
import QtQuick.Layouts 1.0
import QtQuick.Dialogs 1.1
import Shotcut.Controls 1.0 as Shotcut
Shotcut.KeyframableFilter {
    width: 350
    height: 600
    property var allParameters: [
        {
            name: "analyze",
            type: "checkbox",
            def: false
        },
        {
            name: "transformWhenAnalyzing",
            type: "checkbox",
            def: true
        },
        {
            name: "interpolation",
            type: "combobox",
            def: 1
        },
        {
            name: "sampleRadius",
            type: "static",
            def: 16
        },
        {
            name: "searchRadius",
            type: "static",
            def: 24
        },
        {
            name: "offset",
            type: "static",
            def: 64
        },
        {
            name: "subpixels",
            type: "combobox",
            def: 1
        },
        {
            name: "analysisFile",
            type: "textfield",
            def: ""
        },
        {
            name: "clipOffset",
            type: "numtextfield",
            def: 0
        },
        {
            name: "useBackTrackpoints",
            type: "checkbox",
            def: false
        },
        {
            name: "stabilizeYaw",
            type: "static",
            def: 100
        },
        {
            name: "stabilizePitch",
            type: "static",
            def: 100
        },
        {
            name: "stabilizeRoll",
            type: "static",
            def: 100
        },
        {
            name: "smoothYaw",
            type: "static",
            def: 120
        },
        {
            name: "smoothPitch",
            type: "static",
            def: 120
        },
        {
            name: "smoothRoll",
            type: "static",
            def: 120
        },
        {
            name: "timeBiasYaw",
            type: "static",
            def: 0
        },
        {
            name: "timeBiasPitch",
            type: "static",
            def: 0
        },
        {
            name: "timeBiasRoll",
            type: "static",
            def: 0
        }
        ]
    function isKeyframeButtonChecked(control){
        return filter.animateIn <= 0 && filter.animateOut <= 0 && filter.keyframeCount(control) > 0;
    }
    
    function setSimpleControl(parameter, controlSlider, controlKeyframeButton) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
        controlKeyframeButton.checked = isKeyframeButtonChecked(parameter);
    }
    
    function setSimpleControlStatic(parameter, controlSlider) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
    }
    
    function setSimpleComboBox(parameter, controlComboBox) {
        controlComboBox.currentIndex = filter.get(parameter);
    }
    
    function setSimpleCheckBox(parameter, controlCheckBox) {
        controlCheckBox.checked = filter.get(parameter) == "1";
    }
    
    function setSimpleTextField(parameter, controlTextField) {
        controlTextField.text = filter.get(parameter);
    }
    
    function setSimpleNumTextField(parameter, controlTextField) {
        controlTextField.text = filter.getDouble(parameter).toFixed(4);
    }
    
    function getFrameRate() {
        return producer.getDouble("meta.media.frame_rate_num", getPosition()) / producer.getDouble("meta.media.frame_rate_den", getPosition());
    }
    
    function getClipOffset() {
        return filter.in;
    }
    function getKeyframesButton(param) {
        return this["prop_" + param.name + "KeyframesButton"];
    }
    
    function getControl(param) {
        if (param.control != null && param.control !== undefined) {
            return this["prop_" + param.control];
        } else if (param.type == "simple" || param.type == "static") {
            return this["prop_" + param.name + "Slider"];
        } else if (param.type == "checkbox") {
            return this["prop_" + param.name + "CheckBox"];
        } else if (param.type == "combobox") {
            return this["prop_" + param.name + "ComboBox"];
        } else if (param.type == "textfield" || param.type == "numtextfield") {
            return this["prop_" + param.name + "TextField"];
        } else {
            return null;
        }
    }
    
    function enableControls(enabled) {
        for (var i = 0; i < allParameters.length; ++i) {
            var control = getControl(allParameters[i]);
            control.enabled = enabled;
        }
    }
    
    function defaultBeforePresetLoaded() {
        for (var i in preset.parameters) {
            filter.resetProperty(preset.parameters[i]);
        }
        resetSimpleKeyframes();
    }
    
    function defaultPresetSelected() {
        initializeSimpleKeyframes();
        setControls();
    }
    
    function setControlsForAllParameters() {
        console.log("START");
        console.log(allParameters.length);
        for (var i = 0; i < allParameters.length; ++i) {
            console.log(i);
            var param = allParameters[i];
            var control = getControl(param);
            console.log(param.name);
            console.log(param.type);
            console.log(control);
            if (param.type == "simple") {
                setSimpleControl(param.name, control, getKeyframesButton(param));
            } else if (param.type == "static") {
                setSimpleControlStatic(param.name, control);
            } else if (param.type == "combobox") {
                setSimpleComboBox(param.name, control);
            } else if (param.type == "checkbox") {
                setSimpleCheckBox(param.name, control);
            } else if (param.type == "textfield") {
                setSimpleTextField(param.name, control);
            } else if (param.type == "numtextfield") {
                setSimpleNumTextField(param.name, control);
            }
        }
    }
    function setControls() {
        blockUpdate = true;
        setControlsForAllParameters();
        blockUpdate = false;
        enableControls(isSimpleKeyframesActive());
    }
    
    function defaultOnCompleted() {
        if (filter.isNew) {
            for (var i = 0; i < allParameters.length; ++i) {
                var param = allParameters[i];
                console.log(param.name);
                if (param.def != null) {
                    var control = getControl(param);
                    filter.set(param.name, param.def);
                }
            }
            filter.savePreset(preset.parameters);
        }
        setControls();
    }
    
    function updateSimpleKeyframes() {
        setControlsForAllParameters();
    }
    
    Component.onCompleted: {
        defaultOnCompleted()
    }
    function updateProperty_analyze () {
        if (!blockUpdate) {
            filter.set("analyze", analyzeCheckBox.checked);
        }
    }
    property alias prop_analyzeCheckBox : analyzeCheckBox;
    
    function updateProperty_transformWhenAnalyzing () {
        if (!blockUpdate) {
            filter.set("transformWhenAnalyzing", transformWhenAnalyzingCheckBox.checked);
        }
    }
    property alias prop_transformWhenAnalyzingCheckBox : transformWhenAnalyzingCheckBox;
    
    function updateProperty_interpolation () {
        if (!blockUpdate) {
            filter.set("interpolation", interpolationComboBox.currentIndex);
        }
    }
    property alias prop_interpolationComboBox : interpolationComboBox;
    
    function updateProperty_sampleRadius () {
        if (!blockUpdate) {
            filter.set("sampleRadius", sampleRadiusSlider.value);
        }
    }
    property alias prop_sampleRadiusSlider : sampleRadiusSlider;
    
    function updateProperty_searchRadius () {
        if (!blockUpdate) {
            filter.set("searchRadius", searchRadiusSlider.value);
        }
    }
    property alias prop_searchRadiusSlider : searchRadiusSlider;
    
    function updateProperty_offset () {
        if (!blockUpdate) {
            filter.set("offset", offsetSlider.value);
        }
    }
    property alias prop_offsetSlider : offsetSlider;
    
    function updateProperty_subpixels () {
        if (!blockUpdate) {
            filter.set("subpixels", subpixelsComboBox.currentIndex);
        }
    }
    property alias prop_subpixelsComboBox : subpixelsComboBox;
    
    function updateProperty_analysisFile () {
        if (!blockUpdate) {
            filter.set("analysisFile", analysisFileTextField.text);
        }
    }
    property alias prop_analysisFileTextField : analysisFileTextField;
    
    function updateProperty_clipOffset () {
        if (!blockUpdate) {
            filter.set("clipOffset", parseFloat(clipOffsetTextField.text));
        }
    }
    property alias prop_clipOffsetTextField : clipOffsetTextField;
    
    function updateProperty_useBackTrackpoints () {
        if (!blockUpdate) {
            filter.set("useBackTrackpoints", useBackTrackpointsCheckBox.checked);
        }
    }
    property alias prop_useBackTrackpointsCheckBox : useBackTrackpointsCheckBox;
    
    function updateProperty_stabilizeYaw () {
        if (!blockUpdate) {
            filter.set("stabilizeYaw", stabilizeYawSlider.value);
        }
    }
    property alias prop_stabilizeYawSlider : stabilizeYawSlider;
    
    function updateProperty_stabilizePitch () {
        if (!blockUpdate) {
            filter.set("stabilizePitch", stabilizePitchSlider.value);
        }
    }
    property alias prop_stabilizePitchSlider : stabilizePitchSlider;
    
    function updateProperty_stabilizeRoll () {
        if (!blockUpdate) {
            filter.set("stabilizeRoll", stabilizeRollSlider.value);
        }
    }
    property alias prop_stabilizeRollSlider : stabilizeRollSlider;
    
    function updateProperty_smoothYaw () {
        if (!blockUpdate) {
            filter.set("smoothYaw", smoothYawSlider.value);
        }
    }
    property alias prop_smoothYawSlider : smoothYawSlider;
    
    function updateProperty_smoothPitch () {
        if (!blockUpdate) {
            filter.set("smoothPitch", smoothPitchSlider.value);
        }
    }
    property alias prop_smoothPitchSlider : smoothPitchSlider;
    
    function updateProperty_smoothRoll () {
        if (!blockUpdate) {
            filter.set("smoothRoll", smoothRollSlider.value);
        }
    }
    property alias prop_smoothRollSlider : smoothRollSlider;
    
    function updateProperty_timeBiasYaw () {
        if (!blockUpdate) {
            filter.set("timeBiasYaw", timeBiasYawSlider.value);
        }
    }
    property alias prop_timeBiasYawSlider : timeBiasYawSlider;
    
    function updateProperty_timeBiasPitch () {
        if (!blockUpdate) {
            filter.set("timeBiasPitch", timeBiasPitchSlider.value);
        }
    }
    property alias prop_timeBiasPitchSlider : timeBiasPitchSlider;
    
    function updateProperty_timeBiasRoll () {
        if (!blockUpdate) {
            filter.set("timeBiasRoll", timeBiasRollSlider.value);
        }
    }
    property alias prop_timeBiasRollSlider : timeBiasRollSlider;
    
    FileDialog {
        id: selectAnalysisFile
        title: "File for motion analysis"
        folder: shortcuts.home
        modality: Qt.WindowModal
        selectMultiple: false
        selectExisting: false
        selectFolder: false
        nameFilters: ['Motion Analysis Files (*.bigsh0t360motion)', 'All Files (*)']
        onAccepted: {
            var urlString = selectAnalysisFile.fileUrl.toString()
            analysisFileTextField.text = urlString
            updateProperty_analysisFile()
        }
        onRejected: {
        }
    }
    function toggleMode() {
        if (blockUpdate) return;
        if (analyzeCheckBox.checked && analysisFileTextField.text == "") {
            selectAnalysisFile.open()
        }
        updateProperty_analyze()
    }
    function onClipOffsetUndo() {
        clipOffsetTextField.text = (getClipOffset() / getFrameRate()).toFixed(3)
        updateProperty_clipOffset()
    }
    GridLayout {
        columns: 4
        anchors.fill: parent
        anchors.margins: 8
        Label {
            text: qsTr('Preset')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.Preset {
            id: preset
            parameters: ["sampleRadius", "searchRadius", "offset", "subpixels", "interpolation", "stabilizeYaw", "stabilizePitch", "stabilizeRoll", "smoothYaw", "smoothPitch", "smoothRoll", "timeBiasYaw", "timeBiasPitch", "timeBiasRoll"]
            Layout.columnSpan: 3
            onBeforePresetLoaded: {
                defaultBeforePresetLoaded()
            }
            onPresetSelected: {
                defaultPresetSelected()
            }
        }
        Label {
            text: qsTr('Mode')
            Layout.alignment: Qt.AlignRight
        }
        CheckBox {
            text: qsTr('Analyze')
            checked: false
            partiallyCheckedEnabled: false
            id: analyzeCheckBox
            Layout.columnSpan: 3
            onCheckedChanged: toggleMode()
        }
        Label {
            text: qsTr('File')
            Layout.alignment: Qt.AlignRight
        }
        TextField {
            text: qsTr("")
            id: analysisFileTextField
            Layout.columnSpan: 2
            Layout.fillWidth: true
            Layout.alignment: Qt.AlignLeft
            onEditingFinished: updateProperty_analysisFile()
        }
        Button {
            iconName: 'document-open'
            iconSource: 'qrc:///icons/oxygen/32x32/actions/document-open.png'
            tooltip: qsTr('Browse...')
            implicitWidth: 20
            implicitHeight: 20
            onClicked: selectAnalysisFile.open()
        }
        Label {
            text: qsTr('Start Offset')
            Layout.alignment: Qt.AlignRight
        }
        TextField {
            text: qsTr("0")
            id: clipOffsetTextField
            Layout.columnSpan: 2
            Layout.fillWidth: true
            Layout.alignment: Qt.AlignLeft
            onEditingFinished: updateProperty_clipOffset()
        }
        Shotcut.UndoButton {
            id: clipOffsetUndo
            onClicked: onClipOffsetUndo()
        }
        Label {
            text: qsTr('Interpolation')
            Layout.alignment: Qt.AlignRight
        }
        ComboBox {
            currentIndex: 0
            model: ["Nearest-neighbor", "Bilinear"]
            id: interpolationComboBox
            Layout.columnSpan: 2
            onCurrentIndexChanged: updateProperty_interpolation()
        }
        Shotcut.UndoButton {
            id: interpolationUndo
            onClicked: interpolationComboBox.currentIndex = 1
        }
        Label {
            text: qsTr('Analysis')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('')
            Layout.alignment: Qt.AlignRight
        }
        CheckBox {
            text: qsTr('Apply Transform')
            checked: true
            partiallyCheckedEnabled: false
            id: transformWhenAnalyzingCheckBox
            Layout.columnSpan: 3
            onCheckedChanged: updateProperty_transformWhenAnalyzing()
        }
        Label {
            text: qsTr('Sample Radius')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: sampleRadiusSlider
            minimumValue: 1
            maximumValue: 64
            suffix: ' px'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_sampleRadius(getPosition())
        }
        Shotcut.UndoButton {
            id: sampleRadiusUndo
            onClicked: sampleRadiusSlider.value = 16
        }
        Label {
            text: qsTr('Search Radius')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: searchRadiusSlider
            minimumValue: 1
            maximumValue: 128
            suffix: ' px'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_searchRadius(getPosition())
        }
        Shotcut.UndoButton {
            id: searchRadiusUndo
            onClicked: searchRadiusSlider.value = 24
        }
        Label {
            text: qsTr('Offset')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: offsetSlider
            minimumValue: 1
            maximumValue: 256
            suffix: ' px'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_offset(getPosition())
        }
        Shotcut.UndoButton {
            id: offsetUndo
            onClicked: offsetSlider.value = 64
        }
        Label {
            text: qsTr('Track Points')
            Layout.alignment: Qt.AlignRight
        }
        CheckBox {
            text: qsTr('Use backwards-facing track points')
            checked: false
            partiallyCheckedEnabled: false
            id: useBackTrackpointsCheckBox
            Layout.columnSpan: 3
            onCheckedChanged: updateProperty_useBackTrackpoints()
        }
        Label {
            text: qsTr('Subpixels')
            Layout.alignment: Qt.AlignRight
        }
        ComboBox {
            currentIndex: 0
            model: ["1x1 (disabled)", "2x2", "4x4", "8x8"]
            id: subpixelsComboBox
            Layout.columnSpan: 2
            onCurrentIndexChanged: updateProperty_subpixels()
        }
        Shotcut.UndoButton {
            id: subpixelsUndo
            onClicked: subpixelsComboBox.currentIndex = 0
        }
        Label {
            text: qsTr('Yaw')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('Amount')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: stabilizeYawSlider
            minimumValue: 0
            maximumValue: 100
            suffix: ' %'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_stabilizeYaw(getPosition())
        }
        Shotcut.UndoButton {
            id: stabilizeYawUndo
            onClicked: stabilizeYawSlider.value = 100
        }
        Label {
            text: qsTr('Smoothing')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: smoothYawSlider
            minimumValue: 1
            maximumValue: 300
            suffix: ' frames'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_smoothYaw(getPosition())
        }
        Shotcut.UndoButton {
            id: smoothYawUndo
            onClicked: smoothYawSlider.value = 120
        }
        Label {
            text: qsTr('Time Bias')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: timeBiasYawSlider
            minimumValue: -100
            maximumValue: 100
            suffix: ' %'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_timeBiasYaw(getPosition())
        }
        Shotcut.UndoButton {
            id: timeBiasYawUndo
            onClicked: timeBiasYawSlider.value = 0
        }
        Label {
            text: qsTr('Pitch')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('Amount')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: stabilizePitchSlider
            minimumValue: 0
            maximumValue: 100
            suffix: ' %'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_stabilizePitch(getPosition())
        }
        Shotcut.UndoButton {
            id: stabilizePitchUndo
            onClicked: stabilizePitchSlider.value = 100
        }
        Label {
            text: qsTr('Smoothing')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: smoothPitchSlider
            minimumValue: 1
            maximumValue: 300
            suffix: ' frames'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_smoothPitch(getPosition())
        }
        Shotcut.UndoButton {
            id: smoothPitchUndo
            onClicked: smoothPitchSlider.value = 120
        }
        Label {
            text: qsTr('Time Bias')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: timeBiasPitchSlider
            minimumValue: -100
            maximumValue: 100
            suffix: ' %'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_timeBiasPitch(getPosition())
        }
        Shotcut.UndoButton {
            id: timeBiasPitchUndo
            onClicked: timeBiasPitchSlider.value = 0
        }
        Label {
            text: qsTr('Roll')
            Layout.alignment: Qt.AlignLeft
            Layout.columnSpan: 4
        }
        Label {
            text: qsTr('Amount')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: stabilizeRollSlider
            minimumValue: 0
            maximumValue: 100
            suffix: ' %'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_stabilizeRoll(getPosition())
        }
        Shotcut.UndoButton {
            id: stabilizeRollUndo
            onClicked: stabilizeRollSlider.value = 100
        }
        Label {
            text: qsTr('Smoothing')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: smoothRollSlider
            minimumValue: 1
            maximumValue: 300
            suffix: ' frames'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_smoothRoll(getPosition())
        }
        Shotcut.UndoButton {
            id: smoothRollUndo
            onClicked: smoothRollSlider.value = 120
        }
        Label {
            text: qsTr('Time Bias')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: timeBiasRollSlider
            minimumValue: -100
            maximumValue: 100
            suffix: ' %'
            decimals: 0
            stepSize: 1
            Layout.columnSpan: 2
            onValueChanged: updateProperty_timeBiasRoll(getPosition())
        }
        Shotcut.UndoButton {
            id: timeBiasRollUndo
            onClicked: timeBiasRollSlider.value = 0
        }
    }
    Connections {
        target: filter
        onInChanged: updateSimpleKeyframes();
        onOutChanged: updateSimpleKeyframes();
        onAnimateInChanged: updateSimpleKeyframes();
        onAnimateOutChanged: updateSimpleKeyframes();
        onChanged: setControls();
    }
    
    Connections {
        target: producer;
        onPositionChanged: setControls();
    }
    
}
