"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SVGIcon = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const svgIconStyle = (theme, { color = theme.general.color }) => ({
    fill: color,
    overflow: 'visible',
});
const SVGIcon = (_a) => {
    var { realWidth, realHeight, scale = 1, width = null, height = null, shadow, children } = _a, props = __rest(_a, ["realWidth", "realHeight", "scale", "width", "height", "shadow", "children"]);
    let newScale = scale;
    if (width || height) {
        const widthScale = width ? width / realWidth : Infinity;
        const heightScale = height ? height / realHeight : Infinity;
        newScale = Math.min(widthScale, heightScale);
    }
    const newWidth = Math.ceil(realWidth * newScale);
    const newHeight = Math.ceil(realHeight * newScale);
    const shadowId = shadow && Math.random().toString();
    return ((0, jsx_runtime_1.jsxs)("svg", Object.assign({ css: (theme) => svgIconStyle(theme, props), viewBox: `0 0 ${realWidth} ${realHeight}`, width: newWidth, height: newHeight }, props, { children: [shadow && ((0, jsx_runtime_1.jsx)("defs", { children: (0, jsx_runtime_1.jsxs)("filter", Object.assign({ id: shadowId, x: "-50%", y: "-50%", width: "200%", height: "200%" }, { children: [(0, jsx_runtime_1.jsx)("feOffset", { result: "offOut", in: "SourceAlpha", dx: "0", dy: "0" }), (0, jsx_runtime_1.jsx)("feGaussianBlur", { result: "blurOut", in: "offOut", stdDeviation: "2.5" }), (0, jsx_runtime_1.jsx)("feBlend", { in: "SourceGraphic", in2: "blurOut", mode: "normal" })] })) })), (0, jsx_runtime_1.jsx)("g", Object.assign({ filter: shadow && `url(#${shadowId})` }, { children: children }))] })));
};
exports.SVGIcon = SVGIcon;
