% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_at.R
\name{tween_at_t}
\alias{tween_at_t}
\title{Get several specific position between two states}
\usage{
tween_at_t(from, to, at, ease)
}
\arguments{
\item{from, to}{A data.frame or vector of the same type. If either is of
length/nrow 1 it will get repeated to match the length of the other}

\item{at}{A numeric vector with values between 0 and 1.}

\item{ease}{A character vector giving valid easing functions. Recycled to
match the ncol of \code{from}}
}
\value{
If \code{from}/\code{to} is a data.frame then a data.frame with the same
columns. If \code{from}/\code{to} is a vector then a vector.
}
\description{
This tween is a variation of \code{\link[=tween_at]{tween_at()}}. Instead of having \code{at} refer to
the tweening position of each row, each \code{at} will interpolate the full data
at that position.
}
\examples{
tween_at_t(mtcars[1:6, ], mtcars[6:1, ], runif(3), 'cubic-in-out')

}
