% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe_consistency_linter.R
\name{pipe_consistency_linter}
\alias{pipe_consistency_linter}
\title{Pipe consistency linter}
\usage{
pipe_consistency_linter(pipe = c("auto", "\%>\%", "|>"))
}
\arguments{
\item{pipe}{Which pipe operator is valid (either \code{"\%>\%"} or \code{"|>"}). By default
(\code{"auto"}), the linter has no preference but will check that each file uses
only one type of pipe operator.}
}
\description{
Check that pipe operators are used consistently by file, or optionally
specify one valid pipe operator.
}
\examples{
# will produce lints
lint(
  text = "1:3 |> mean() \%>\% as.character()",
  linters = pipe_consistency_linter()
)

lint(
  text = "1:3 \%>\% mean() \%>\% as.character()",
  linters = pipe_consistency_linter("|>")
)

# okay
lint(
  text = "1:3 \%>\% mean() \%>\% as.character()",
  linters = pipe_consistency_linter()
)

lint(
  text = "1:3 |> mean() |> as.character()",
  linters = pipe_consistency_linter()
)
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
