% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indentation_linter.R
\name{indentation_linter}
\alias{indentation_linter}
\title{Check that indentation is consistent}
\usage{
indentation_linter(
  indent = 2L,
  hanging_indent_style = c("tidy", "always", "never"),
  assignment_as_infix = TRUE
)
}
\arguments{
\item{indent}{Number of spaces, that a code block should be indented by relative to its parent code block.
Used for multi-line code blocks (\code{{ ... }}), function calls (\code{( ... )}) and extractions (\verb{[ ... ]}, \verb{[[ ... ]]}).
Defaults to 2.}

\item{hanging_indent_style}{Indentation style for multi-line function calls with arguments in their first line.
Defaults to tidyverse style, i.e. a block indent is used if the function call terminates with \verb{)} on a separate
line and a hanging indent if not.
Note that function multi-line function calls without arguments on their first line will always be expected to have
block-indented arguments.
If \code{hanging_indent_style} is \code{"tidy"}, multi-line function definitions are expected to be double-indented if the
first line of the function definition contains no arguments and the closing parenthesis is not on its own line.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# complies to any style
map(
  x,
  f,
  additional_arg = 42
)

# complies to "tidy" and "never"
map(x, f,
  additional_arg = 42
)

# complies to "always"
map(x, f,
    additional_arg = 42
)

# complies to "tidy" and "always"
map(x, f,
    additional_arg = 42)

# complies to "never"
map(x, f,
  additional_arg = 42)

# complies to "tidy"
function(
    a,
    b) \{
  # body
\}
}\if{html}{\out{</div>}}}

\item{assignment_as_infix}{Treat \verb{<-} as a regular (i.e. left-associative) infix operator?
This means, that infix operators on the right hand side of an assignment do not trigger a second level of
indentation:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# complies to any style
variable <- a \%+\%
  b \%+\%
  c

# complies to assignment_as_infix = TRUE
variable <-
  a \%+\%
  b \%+\%
  c

# complies to assignment_as_infix = FALSE
variable <-
  a \%+\%
    b \%+\%
    c
}\if{html}{\out{</div>}}}
}
\description{
Check that indentation is consistent
}
\examples{
# will produce lints
code_lines <- "if (TRUE) {\n1 + 1\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = indentation_linter()
)

code_lines <- "if (TRUE) {\n    1 + 1\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = indentation_linter()
)

code_lines <- "map(x, f,\n  additional_arg = 42\n)"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = indentation_linter(hanging_indent_style = "always")
)

code_lines <- "map(x, f,\n    additional_arg = 42)"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = indentation_linter(hanging_indent_style = "never")
)

# okay
code_lines <- "map(x, f,\n  additional_arg = 42\n)"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = indentation_linter()
)

code_lines <- "if (TRUE) {\n    1 + 1\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = indentation_linter(indent = 4)
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#indenting}
\item \url{https://style.tidyverse.org/functions.html#long-lines-1}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
