\name{zscoreNBinom}
\alias{zscoreNBinom}

\title{Z-score Equivalents of Negative Binomial Deviate}

\description{
Compute z-score equivalents of negative binomial random deviates.
}

\usage{
zscoreNBinom(q, size, mu, method = "midp")
}

\arguments{
\item{q}{numeric vector or matrix of non-negative quantiles.}
\item{size}{numeric vector of non-negative size parameters.}
\item{mu}{numeric vector of means.}
\item{method}{method for converting from discrete to continuous distribution.
  Possible values are \code{"midp"} or \code{"random"}.}
}

\value{
Numeric vector or matrix giving equivalent quantiles from the standard normal distribution.
}

\details{
The mid-p method (\code{method=="midp"}) applies a continuity correction by splitting the probability mass of each integer in two.
It computes the mid-p tail probability of \code{q}, then converts to the standard normal deviate with the same cumulative probability distribution value.
Care is taken to do the computations accurately in both tails of the distributions.

The randomized method (\code{method=="random"}) computes randomized quantile residuals (Dunn and Smyth, 1996).
In this method, the tail probabilities are randomized over the possible values covered by the discrete integer counts.
If \code{q} follows a negative binomial distribution with the size and mean correctly specified, then the z-values generated by the randomized method are exactly standard normal.

Non-integer values of \code{q} are allowed.
The mid-p method handles non-integer values by interpolation while the randomized method rounds \code{q} to integers.
}
 
\references{
Berry, G., & Armitage, P. (1995).
Mid-P confidence intervals: a brief review.
\emph{The Statistician}, 417-423.

Dunn, K. P., and Smyth, G. K. (1996).
Randomized quantile residuals.
\emph{Journal of Computational and Graphical Statistics} \bold{5}, 1-10.
\url{https://gksmyth.github.io/pubs/residual.html}
}

\author{Gordon Smyth}
\seealso{
\code{\link{pnbinom}}, \code{\link{qnorm}} in the stats package.
}
\examples{
zscoreNBinom(c(0,10,100), mu=10, size=10)
}
