% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HnswIndex-class.R
\docType{class}
\name{HnswIndex}
\alias{HnswIndex}
\alias{HnswIndex-class}
\alias{show,HnswIndex-method}
\alias{HnswIndex_path}
\alias{HnswIndex_ef_search}
\alias{bnorder,HnswIndex-method}
\title{The HnswIndex class}
\usage{
HnswIndex(data, path, ef.search = 10, NAMES = NULL, distance = "Euclidean")
}
\arguments{
\item{data}{A numeric matrix with data points in columns and dimensions in rows.}

\item{path}{A string specifying the path to the index file.}

\item{ef.search}{Integer scalar specifying the size of the dynamic list at run time.}

\item{NAMES}{A character vector of sample names or \code{NULL}.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An instance of the HnswIndex class.
}
\description{
A class to hold indexing structures for the HNSW algorithm for approximate nearest neighbor identification.
}
\details{
The HnswIndex class holds the indexing structure required to run the HNSW algorithm.
Users should never need to call the constructor explicitly, but should generate instances of HnswIndex classes with \code{\link{buildHnsw}}.

Users can get values from an HnswIndex object with the usual \code{[[} syntax.
All parameters listed in the constructor can be extracted in this manner.
}
\examples{
example(buildHnsw)
out[['path']]

}
\seealso{
\code{\link{buildHnsw}}, to build the index.

\linkS4class{BiocNeighborIndex}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
