# == Class: vmms::source_cloud
#
# Configures VMMS to connect to the source_cloud from which migrations occurs.
#
# === Parameters:
#
# [*password*]
#   (required) Password for connecting to the source_cloud services in
#   admin context through the OpenStack Identity service.
#
# [*auth_type*]
#   Name of the auth type to load (string value)
#   Defaults to 'password'
#
# [*project_name*]
#   (optional) Project name for connecting to the source_cloud services in
#   admin context through the OpenStack Identity service.
#   Defaults to 'admin'
#
# [*project_domain_name*]
#   (optional) Project Domain name for connecting to source_cloud services in
#   admin context through the OpenStack Identity service.
#   Defaults to 'Default'
#
# [*username*]
#   (optional) Username for connecting to the source_cloud services in admin context
#   through the OpenStack Identity service.
#   Defaults to 'admin'
#
# [*user_domain_name*]
#   (optional) User Domain name for connecting to the source_cloud services in
#   admin context through the OpenStack Identity service.
#   Defaults to 'Default'
#
# [*auth_url*]
#   (optional) Points to the OpenStack Identity server IP and port.
#   This is the Identity (keystone) admin API server IP and port value,
#   and not the Identity service API IP and port.
#   Defaults to 'http://127.0.0.1:5000/v3'
#
# [*region_name*]
#   (optional) Region name for connecting to the source_cloud in admin context
#   through the OpenStack Identity service.
#   Defaults to 'RegionOne'
#
class vmms::source_cloud (
  $password,
  $auth_type           = 'password',
  $project_name        = 'admin',
  $project_domain_name = 'Default',
  $username            = 'admin',
  $user_domain_name    = 'Default',
  $auth_url            = 'http://127.0.0.1:5000/v3',
  $region_name         = 'RegionOne',
) {

  include vmms::deps

  vmms_config {
    'source_cloud/password':                value => $password, secret => true;
    'source_cloud/auth_type':               value => 'password';
    'source_cloud/auth_url':                value => $auth_url;
    'source_cloud/project_name':            value => $project_name;
    'source_cloud/project_domain_name':     value => $project_domain_name;
    'source_cloud/username':                value => $username;
    'source_cloud/user_domain_name':        value => $user_domain_name;
    'source_cloud/region_name':             value => $region_name;
  }
}
