/*****************************************************************************
 * Test cases for libxlsxwriter.
 *
 * Test to compare output against Excel files.
 *
 * Copyright 2014-2021, John McNamara, jmcnamara@cpan.org
 *
 */

#include "xlsxwriter.h"

int main() {

    lxw_workbook  *workbook  = workbook_new("test_hyperlink78.xlsx");
    lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);

    lxw_format *default_url_format = workbook_get_default_url_format(workbook);

    worksheet_write_url(worksheet, CELL("A1"), "http://www.perl.org/", default_url_format);

    return workbook_close(workbook);
}
